/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfo;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.impl.DefaultFileContentInfo;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.webdav.WebdavFileObject;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class WebdavFileContentInfoFactory
implements FileContentInfoFactory {
    public FileContentInfo create(FileContent fileContent) throws FileSystemException {
        WebdavFileObject file = (WebdavFileObject)fileContent.getFile();
        String contentType = null;
        String contentEncoding = null;
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.GETCONTENTTYPE);
        DavPropertySet propertySet = file.getProperties((URLFileName)file.getName(), nameSet, true);
        DavProperty property = propertySet.get(DavPropertyName.GETCONTENTTYPE);
        if (property != null) {
            contentType = (String)property.getValue();
        }
        if ((property = propertySet.get(WebdavFileObject.RESPONSE_CHARSET)) != null) {
            contentEncoding = (String)property.getValue();
        }
        return new DefaultFileContentInfo(contentType, contentEncoding);
    }
}

