/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.util;

import java.lang.ref.WeakReference;
import org.apache.commons.vfs.FileChangeEvent;
import org.apache.commons.vfs.FileListener;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;

public class WeakRefFileListener
implements FileListener {
    private final FileSystem fs;
    private final FileName name;
    private final WeakReference listener;

    protected WeakRefFileListener(FileObject file, FileListener listener) {
        this.fs = file.getFileSystem();
        this.name = file.getName();
        this.listener = new WeakReference<FileListener>(listener);
    }

    public static void installListener(FileObject file, FileListener listener) {
        WeakRefFileListener weakListener = new WeakRefFileListener(file, listener);
        file.getFileSystem().addListener(file, new WeakRefFileListener(file, weakListener));
    }

    protected FileListener getListener() throws Exception {
        FileListener listener = (FileListener)this.listener.get();
        if (listener == null) {
            FileObject file = this.fs.resolveFile(this.name);
            file.getFileSystem().removeListener(file, this);
        }
        return listener;
    }

    public void fileCreated(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileCreated(event);
    }

    public void fileDeleted(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileDeleted(event);
    }

    public void fileChanged(FileChangeEvent event) throws Exception {
        FileListener listener = this.getListener();
        if (listener == null) {
            return;
        }
        listener.fileChanged(event);
    }
}

