/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.util;

import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticationData;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;

public final class UserAuthenticatorUtils {
    public static UserAuthenticationData authenticate(FileSystemOptions options, UserAuthenticationData.Type[] authenticatorTypes) {
        UserAuthenticator auth = DefaultFileSystemConfigBuilder.getInstance().getUserAuthenticator(options);
        return UserAuthenticatorUtils.authenticate(auth, authenticatorTypes);
    }

    public static UserAuthenticationData authenticate(UserAuthenticator auth, UserAuthenticationData.Type[] authenticatorTypes) {
        if (auth == null) {
            return null;
        }
        return auth.requestAuthentication(authenticatorTypes);
    }

    public static void cleanup(UserAuthenticationData authData) {
        if (authData != null) {
            authData.cleanup();
        }
    }

    public static char[] getData(UserAuthenticationData data, UserAuthenticationData.Type type, char[] overriddenValue) {
        if (overriddenValue != null) {
            return overriddenValue;
        }
        if (data == null) {
            return null;
        }
        return data.getData(type);
    }

    public static char[] toChar(String string) {
        if (string == null) {
            return null;
        }
        return string.toCharArray();
    }

    public static String toString(char[] data) {
        if (data == null) {
            return null;
        }
        return new String(data);
    }

    private UserAuthenticatorUtils() {
    }
}

