/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.Properties;
import org.apache.curator.test.FailedServerStartException;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.ZooKeeperMainFace;
import org.apache.zookeeper.server.embedded.ZooKeeperServerEmbedded;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperServerEmbeddedAdapter
implements ZooKeeperMainFace {
    private static final Logger log = LoggerFactory.getLogger(ZooKeeperServerEmbeddedAdapter.class);
    private static final Duration DEFAULT_STARTUP_TIMEOUT = Duration.ofMinutes(1L);
    private volatile ZooKeeperServerEmbedded zooKeeperEmbedded;
    private volatile QuorumConfigBuilder configBuilder;
    private volatile int instanceIndex;

    @Override
    public void configure(QuorumConfigBuilder config, int instanceIndex) throws Exception {
        this.configBuilder = config;
        this.instanceIndex = instanceIndex;
        Properties properties = config.buildConfigProperties(instanceIndex);
        properties.put("admin.enableServer", "false");
        Path dataDir = Paths.get(properties.getProperty("dataDir"), new String[0]);
        this.zooKeeperEmbedded = ZooKeeperServerEmbedded.builder().configuration(properties).baseDir(dataDir.getParent()).build();
        log.info("Configure ZooKeeperServerEmbeddedAdapter with properties: {}", (Object)properties);
    }

    @Override
    public QuorumPeerConfig getConfig() throws Exception {
        if (this.configBuilder != null) {
            return this.configBuilder.buildConfig(this.instanceIndex);
        }
        return null;
    }

    @Override
    public void start() {
        if (this.zooKeeperEmbedded == null) {
            throw new FailedServerStartException(new NullPointerException("zooKeeperEmbedded"));
        }
        try {
            this.zooKeeperEmbedded.start(DEFAULT_STARTUP_TIMEOUT.toMillis());
        }
        catch (Exception e) {
            throw new FailedServerStartException(e);
        }
    }

    @Override
    public void kill() {
        this.close();
    }

    @Override
    public void close() {
        if (this.zooKeeperEmbedded != null) {
            this.zooKeeperEmbedded.close();
        }
    }
}

