/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.TestingZooKeeperServer;

public class TestingServer
implements Closeable {
    private final TestingZooKeeperServer testingZooKeeperServer;
    private final InstanceSpec spec;

    TestingZooKeeperServer getTestingZooKeeperServer() {
        return this.testingZooKeeperServer;
    }

    public TestingServer() throws Exception {
        this(-1, null, true);
    }

    public TestingServer(boolean start) throws Exception {
        this(-1, null, start);
    }

    public TestingServer(int port) throws Exception {
        this(port, null, true);
    }

    public TestingServer(int port, boolean start) throws Exception {
        this(port, null, start);
    }

    public TestingServer(int port, File tempDirectory) throws Exception {
        this(port, tempDirectory, true);
    }

    public TestingServer(int port, File tempDirectory, boolean start) throws Exception {
        this(new InstanceSpec(tempDirectory, Math.max(0, port), -1, -1, true, -1), start);
    }

    public TestingServer(InstanceSpec spec, boolean start) throws Exception {
        this.spec = spec;
        this.testingZooKeeperServer = new TestingZooKeeperServer(new QuorumConfigBuilder(spec));
        if (start) {
            this.testingZooKeeperServer.start();
        }
    }

    public int getPort() {
        int port = this.spec.getPort();
        if (port > 0) {
            return port;
        }
        return this.testingZooKeeperServer.getLocalPort();
    }

    public File getTempDirectory() {
        return this.spec.getDataDirectory();
    }

    public void start() throws Exception {
        this.testingZooKeeperServer.start();
    }

    public void stop() throws IOException {
        this.testingZooKeeperServer.stop();
    }

    public void restart() throws Exception {
        this.testingZooKeeperServer.restart();
    }

    @Override
    public void close() throws IOException {
        this.testingZooKeeperServer.close();
    }

    public String getConnectString() {
        return this.spec.getHostname() + ":" + this.getPort();
    }
}

