/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.maven.plugins.shade.resource.ResourceTransformer;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class CXFAllTransformer
implements ResourceTransformer {
    byte[] buffer = new byte[1024];
    Map<String, ByteArrayOutputStream> extensions = new LinkedHashMap<String, ByteArrayOutputStream>();
    String lastResource;

    public boolean canTransformResource(String r) {
        if (r.startsWith("META-INF/cxf/cxf-extension-") && r.endsWith(".xml")) {
            this.lastResource = r;
            return true;
        }
        return false;
    }

    public boolean hasTransformedResource() {
        return !this.extensions.isEmpty();
    }

    public void processResource(String resource, InputStream is, List relocators) throws IOException {
        this.processResource(is);
    }

    public void processResource(InputStream is) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        int i = is.read(this.buffer);
        while (i != -1) {
            bout.write(this.buffer, 0, i);
            i = is.read(this.buffer);
        }
        this.extensions.put(this.lastResource, bout);
    }

    public void modifyOutputStream(JarOutputStream jos) throws IOException {
        ArrayList<String> imps = new ArrayList<String>(this.extensions.keySet());
        for (Map.Entry<String, ByteArrayOutputStream> ent : this.extensions.entrySet()) {
            jos.putNextEntry(new JarEntry(ent.getKey()));
            ent.getValue().writeTo(jos);
            try {
                Document r = new SAXBuilder().build((InputStream)new ByteArrayInputStream(ent.getValue().toByteArray()));
                Element root = r.getRootElement();
                for (Content n : root.getChildren()) {
                    String loc;
                    Element e;
                    if (!(n instanceof Element) || !"import".equals((e = (Element)n).getName()) || !"http://www.springframework.org/schema/beans".equals(e.getNamespaceURI()) || !(loc = e.getAttributeValue("resource")).startsWith("classpath:META-INF/cxf/cxf")) continue;
                    loc = loc.substring(10);
                    imps.remove(loc);
                }
            }
            catch (JDOMException e) {
                throw new RuntimeException(e);
            }
        }
        if (imps.size() > 0) {
            jos.putNextEntry(new JarEntry("META-INF/cxf/cxf-all.xml"));
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)jos, "UTF-8");
            ((Writer)writer).append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            ((Writer)writer).append("<beans xmlns=\"http://www.springframework.org/schema/beans\"\n");
            ((Writer)writer).append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
            ((Writer)writer).append("    xsi:schemaLocation=\"");
            ((Writer)writer).append("http://www.springframework.org/schema/beans ");
            ((Writer)writer).append("http://www.springframework.org/schema/beans/spring-beans.xsd\">\n");
            ((Writer)writer).append("    <import resource=\"classpath:META-INF/cxf/cxf.xml\"/>\n");
            for (String res : imps) {
                ((Writer)writer).append("    <import resource=\"classpath:");
                ((Writer)writer).append(res);
                ((Writer)writer).append("\"/>\n");
            }
            ((Writer)writer).append("</beans>");
            ((Writer)writer).flush();
        }
    }
}

