/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.feature;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.InterceptorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFeature {
    public void initialize(Server server, Bus bus) {
        this.initializeProvider(server.getEndpoint(), bus);
    }

    public void initialize(Client client, Bus bus) {
        this.initializeProvider(client, bus);
    }

    public void initialize(InterceptorProvider interceptorProvider, Bus bus) {
        this.initializeProvider(interceptorProvider, bus);
    }

    public void initialize(Bus bus) {
        this.initializeProvider(bus, bus);
    }

    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
    }

    public static <T> T getActive(List<AbstractFeature> features, Class<T> type) {
        T active = null;
        if (features != null) {
            for (AbstractFeature feature : features) {
                if (!type.isInstance(feature)) continue;
                active = type.cast(feature);
                break;
            }
        }
        return active;
    }
}

