/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.annotation.Annotation;
import java.util.LinkedList;
import java.util.List;
import javax.ws.rs.Path;
import javax.ws.rs.ext.Provider;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.spring.AbstractSpringConfigurationFactory;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={Path.class, Provider.class})})
public abstract class AbstractSpringComponentScanServer
extends AbstractSpringConfigurationFactory {
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private List<Object> jaxrsProviders = new LinkedList<Object>();

    @Override
    protected void setRootResources(JAXRSServerFactoryBean factory) {
        boolean checkJaxrsRoots = this.checkJaxrsRoots();
        boolean checkJaxrsProviders = this.checkJaxrsProviders();
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            if (checkJaxrsRoots && this.isAnnotationAvailable(beanName, Path.class)) {
                SpringResourceFactory resourceFactory = new SpringResourceFactory(beanName);
                resourceFactory.setApplicationContext(this.applicationContext);
                this.resourceProviders.add(resourceFactory);
                continue;
            }
            if (!checkJaxrsProviders || !this.isAnnotationAvailable(beanName, Provider.class)) continue;
            this.jaxrsProviders.add(this.applicationContext.getBean(beanName));
        }
        factory.setResourceProviders(this.getResourceProviders());
    }

    protected <A extends Annotation> boolean isAnnotationAvailable(String beanName, Class<A> annClass) {
        return this.applicationContext.findAnnotationOnBean(beanName, annClass) != null;
    }

    protected boolean checkJaxrsProviders() {
        return true;
    }

    protected boolean checkJaxrsRoots() {
        return true;
    }

    protected List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    protected List<Object> getJaxrsProviders() {
        return this.jaxrsProviders;
    }
}

