/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.CorbaConstants;
import org.apache.cxf.binding.corba.wsdl.CorbaType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.RaisesType;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ObjectReferenceVisitor;
import org.apache.cxf.tools.corba.processors.idl.OperationDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.ParamDclVisitor;
import org.apache.cxf.tools.corba.processors.idl.ParamTypeSpecVisitor;
import org.apache.cxf.tools.corba.processors.idl.PrimitiveTypesVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.ScopedNameVisitor;
import org.apache.cxf.tools.corba.processors.idl.StringVisitor;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class OperationVisitor
extends VisitorBase {
    private static final String REQUEST_SUFFIX = "Request";
    private static final String RESPONSE_SUFFIX = "Response";
    private static final String IN_PARAMETER = "inparameter";
    private static final String OUT_PARAMETER = "outparameter";
    private static final String RETURN_PARAMETER = "return";
    private ExtensionRegistry extReg;
    private PortType portType;
    private Binding binding;
    private Message inputMsg;
    private Message outputMsg;
    private OperationType corbaOperation;

    public OperationVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, PortType wsdlPortType, Binding wsdlBinding) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.extReg = this.definition.getExtensionRegistry();
        this.portType = wsdlPortType;
        this.binding = wsdlBinding;
    }

    public static boolean accept(Scope scope, Definition def, XmlSchema schema, AST node, WSDLASTVisitor wsdlVisitor) {
        boolean result = false;
        AST node2 = node.getFirstChild();
        if (null != node2) {
            int type;
            result = node2.getType() == 68 ? true : (type = node2.getType()) == 69 || PrimitiveTypesVisitor.accept(node2) || StringVisitor.accept(node2) || ScopedNameVisitor.accept(scope, def, schema, node2, wsdlVisitor) || ObjectReferenceVisitor.accept(scope, schema, def, node2, wsdlVisitor);
        }
        return result;
    }

    @Override
    public void visit(AST node) {
        VisitorBase visitor;
        QName operationQName = new QName(this.schema.getTargetNamespace(), node.toString());
        boolean isDuplicate = false;
        if (this.schema.getElements().containsKey(operationQName)) {
            isDuplicate = true;
        }
        Operation operation = this.generateOperation(operationQName.getLocalPart(), isDuplicate);
        BindingOperation bindingOperation = null;
        bindingOperation = isDuplicate ? this.generateBindingOperation(this.binding, operation, operationQName.getLocalPart()) : this.generateBindingOperation(this.binding, operation, operation.getName());
        XmlSchemaSequence inputWrappingSequence = new XmlSchemaSequence();
        XmlSchemaElement inputElement = this.generateWrapper(new QName(this.schema.getTargetNamespace(), operation.getName()), inputWrappingSequence);
        this.inputMsg = this.generateInputMessage(operation, bindingOperation);
        this.generateInputPart(this.inputMsg, inputElement);
        node = node.getFirstChild();
        XmlSchemaSequence outputWrappingSequence = null;
        XmlSchemaElement outputElement = null;
        if (node != null && node.getType() == 68) {
            node = node.getNextSibling();
        } else {
            outputWrappingSequence = new XmlSchemaSequence();
            outputElement = this.generateWrapper(new QName(this.schema.getTargetNamespace(), operation.getName() + RESPONSE_SUFFIX), outputWrappingSequence);
            this.outputMsg = this.generateOutputMessage(operation, bindingOperation);
            this.generateOutputPart(this.outputMsg, outputElement);
        }
        this.visitOpTypeSpec(node, outputWrappingSequence);
        node = TypesUtils.getCorbaTypeNameNode(node);
        while (ParamDclVisitor.accept(node)) {
            visitor = new ParamDclVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor, inputWrappingSequence, outputWrappingSequence, this.corbaOperation);
            ((ParamDclVisitor)visitor).visit(node);
            node = node.getNextSibling();
        }
        if (node != null && node.getType() == 72) {
            for (node = node.getFirstChild(); node != null; node = node.getNextSibling()) {
                visitor = new ScopedNameVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
                ((ScopedNameVisitor)visitor).setExceptionMode(true);
                ((ScopedNameVisitor)visitor).visit(node);
                CorbaType corbaType = visitor.getCorbaType();
                XmlSchemaType schemaType = visitor.getSchemaType();
                int pos = schemaType.getQName().getLocalPart().indexOf("Type");
                QName elementQName = new QName(schemaType.getQName().getNamespaceURI(), schemaType.getQName().getLocalPart().substring(0, pos));
                this.createFaultMessage(corbaType, operation, bindingOperation, elementQName);
                ((ScopedNameVisitor)visitor).setExceptionMode(false);
            }
        }
    }

    private Operation generateOperation(String name, boolean isDuplicate) {
        Operation op = this.definition.createOperation();
        if (isDuplicate) {
            String prefix = this.getScope().toString().replace('.', '_');
            name = prefix + "_" + name;
        }
        op.setName(name);
        op.setUndefined(false);
        this.portType.addOperation(op);
        return op;
    }

    private BindingOperation generateBindingOperation(Binding wsdlBinding, Operation op, String corbaOpName) {
        BindingOperation bindingOperation = this.definition.createBindingOperation();
        try {
            this.corbaOperation = (OperationType)this.extReg.createExtension(BindingOperation.class, CorbaConstants.NE_CORBA_OPERATION);
        }
        catch (WSDLException ex) {
            throw new RuntimeException(ex);
        }
        this.corbaOperation.setName(corbaOpName);
        bindingOperation.addExtensibilityElement((ExtensibilityElement)this.corbaOperation);
        bindingOperation.setOperation(op);
        bindingOperation.setName(op.getName());
        this.binding.addBindingOperation(bindingOperation);
        return bindingOperation;
    }

    public Message generateInputMessage(Operation operation, BindingOperation bindingOperation) {
        Message msg = this.definition.createMessage();
        QName msgName = !this.mapper.isDefaultMapping() ? new QName(this.definition.getTargetNamespace(), this.getScope().tail() + "." + operation.getName()) : new QName(this.definition.getTargetNamespace(), operation.getName());
        msg.setQName(msgName);
        msg.setUndefined(false);
        String inputName = operation.getName() + REQUEST_SUFFIX;
        Input input = this.definition.createInput();
        input.setName(inputName);
        input.setMessage(msg);
        BindingInput bindingInput = this.definition.createBindingInput();
        bindingInput.setName(inputName);
        bindingOperation.setBindingInput(bindingInput);
        operation.setInput(input);
        this.definition.addMessage(msg);
        return msg;
    }

    public Message generateOutputMessage(Operation operation, BindingOperation bindingOperation) {
        Message msg = this.definition.createMessage();
        QName msgName = !this.mapper.isDefaultMapping() ? new QName(this.definition.getTargetNamespace(), this.getScope().tail() + "." + operation.getName() + RESPONSE_SUFFIX) : new QName(this.definition.getTargetNamespace(), operation.getName() + RESPONSE_SUFFIX);
        msg.setQName(msgName);
        msg.setUndefined(false);
        String outputName = operation.getName() + RESPONSE_SUFFIX;
        Output output = this.definition.createOutput();
        output.setName(outputName);
        output.setMessage(msg);
        BindingOutput bindingOutput = this.definition.createBindingOutput();
        bindingOutput.setName(outputName);
        bindingOperation.setBindingOutput(bindingOutput);
        operation.setOutput(output);
        this.definition.addMessage(msg);
        return msg;
    }

    private Part generateInputPart(Message inputMessage, XmlSchemaElement element) {
        Part part = this.definition.createPart();
        part.setName(IN_PARAMETER);
        part.setElementName(element.getQName());
        inputMessage.addPart(part);
        return part;
    }

    private Part generateOutputPart(Message outputMessage, XmlSchemaElement element) {
        Part part = this.definition.createPart();
        part.setName(OUT_PARAMETER);
        part.setElementName(element.getQName());
        outputMessage.addPart(part);
        return part;
    }

    private XmlSchemaElement generateWrapper(QName el, XmlSchemaSequence wrappingSequence) {
        XmlSchemaComplexType schemaComplexType = new XmlSchemaComplexType(this.schema, false);
        schemaComplexType.setParticle((XmlSchemaParticle)wrappingSequence);
        XmlSchemaElement wrappingSchemaElement = new XmlSchemaElement(this.schema, true);
        wrappingSchemaElement.setName(el.getLocalPart());
        wrappingSchemaElement.setSchemaType((XmlSchemaType)schemaComplexType);
        return wrappingSchemaElement;
    }

    private XmlSchemaElement addElement(XmlSchemaSequence schemaSequence, XmlSchemaType schemaType, Scope fqName, String name) {
        XmlSchemaElement element = new XmlSchemaElement(this.schema, false);
        element.setName(name);
        if (schemaType != null) {
            element.setSchemaTypeName(schemaType.getQName());
            if (schemaType.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                element.setNillable(true);
            }
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new OperationDeferredAction(element));
        }
        schemaSequence.getItems().add(element);
        return element;
    }

    private void visitOpTypeSpec(AST node, XmlSchemaSequence outputWrappingSequence) {
        if (node.getType() == 69) {
            return;
        }
        ParamTypeSpecVisitor visitor = new ParamTypeSpecVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
        visitor.visit(node);
        XmlSchemaType schemaType = visitor.getSchemaType();
        CorbaType corbaType = visitor.getCorbaType();
        Scope fqName = visitor.getFullyQualifiedName();
        this.addElement(outputWrappingSequence, schemaType, fqName, RETURN_PARAMETER);
        this.addCorbaReturn(corbaType, fqName, RETURN_PARAMETER);
    }

    private void addCorbaReturn(CorbaTypeImpl corbaType, Scope fqName, String partName) {
        ArgType param = new ArgType();
        param.setName(partName);
        if (corbaType != null) {
            param.setIdltype(corbaType.getQName());
        } else {
            this.wsdlVisitor.getDeferredActions().add(fqName, new OperationDeferredAction(param));
        }
        this.corbaOperation.setReturn(param);
    }

    private void createFaultMessage(CorbaTypeImpl corbaType, Operation operation, BindingOperation bindingOperation, QName elementQName) {
        Message faultMsg;
        String exceptionName = corbaType.getQName().getLocalPart();
        Definition faultDef = this.manager.getWSDLDefinition(elementQName.getNamespaceURI());
        if (faultDef == null) {
            faultDef = this.definition;
        }
        if ((faultMsg = faultDef.getMessage(new QName(faultDef.getTargetNamespace(), exceptionName))) == null) {
            throw new RuntimeException("Fault message for exception " + exceptionName + " not found");
        }
        Fault fault = this.definition.createFault();
        fault.setMessage(faultMsg);
        fault.setName(faultMsg.getQName().getLocalPart());
        operation.addFault(fault);
        RaisesType raisesType = new RaisesType();
        raisesType.setException(new QName(this.typeMap.getTargetNamespace(), exceptionName));
        this.corbaOperation.getRaises().add(raisesType);
        BindingFault bindingFault = this.definition.createBindingFault();
        bindingFault.setName(faultMsg.getQName().getLocalPart());
        bindingOperation.addBindingFault(bindingFault);
        String nsURI = elementQName.getNamespaceURI();
        this.manager.addWSDLDefinitionNamespace(this.definition, this.mapper.mapNSToPrefix(nsURI), nsURI);
    }
}

