/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.jms;

import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.ConnectionFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.jms.JMSConfiguration;
import org.apache.cxf.transport.jms.uri.JMSEndpoint;
import org.apache.cxf.transport.jms.util.JMSDestinationResolver;
import org.apache.cxf.transport.jms.util.JndiHelper;
import org.apache.cxf.ws.addressing.EndpointReferenceType;

public final class JMSConfigFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(JMSConfigFactory.class);

    private JMSConfigFactory() {
    }

    public static JMSConfiguration createFromEndpointInfo(Bus bus, EndpointInfo endpointInfo, EndpointReferenceType target) {
        JMSEndpoint jmsEndpoint = new JMSEndpoint(endpointInfo, target);
        return JMSConfigFactory.createFromEndpoint(bus, jmsEndpoint);
    }

    public static JMSConfiguration createFromEndpoint(Bus bus, JMSEndpoint endpoint) {
        JMSConfiguration jmsConfig = new JMSConfiguration();
        int deliveryMode = endpoint.getDeliveryMode() == JMSEndpoint.DeliveryModeType.PERSISTENT ? 2 : 1;
        jmsConfig.setDeliveryMode(deliveryMode);
        jmsConfig.setPriority(endpoint.getPriority());
        jmsConfig.setReconnectOnException(endpoint.isReconnectOnException());
        jmsConfig.setExplicitQosEnabled(true);
        jmsConfig.setMessageType(endpoint.getMessageType().value());
        boolean pubSubDomain = endpoint.getJmsVariant().contains("topic");
        jmsConfig.setPubSubDomain(pubSubDomain);
        jmsConfig.setDurableSubscriptionName(endpoint.getDurableSubscriptionName());
        jmsConfig.setDurableSubscriptionClientId(endpoint.getDurableSubscriptionName());
        jmsConfig.setReceiveTimeout(endpoint.getReceiveTimeout());
        jmsConfig.setTimeToLive(endpoint.getTimeToLive());
        jmsConfig.setSessionTransacted(endpoint.isSessionTransacted());
        if (!endpoint.isUseConduitIdSelector()) {
            jmsConfig.setUseConduitIdSelector(endpoint.isUseConduitIdSelector());
        }
        jmsConfig.setConduitSelectorPrefix(endpoint.getConduitIdSelectorPrefix());
        jmsConfig.setUserName(endpoint.getUsername());
        jmsConfig.setPassword(endpoint.getPassword());
        if (endpoint.getJndiURL() != null) {
            jmsConfig.setJndiEnvironment(JMSConfigFactory.getInitialContextEnv(endpoint));
            jmsConfig.setConnectionFactoryName(endpoint.getJndiConnectionFactoryName());
        } else {
            ConnectionFactory cf;
            ConfiguredBeanLocator locator = bus.getExtension(ConfiguredBeanLocator.class);
            if (endpoint.getConnectionFactory() != null) {
                jmsConfig.setConnectionFactory(endpoint.getConnectionFactory());
            } else if (locator != null && (cf = locator.getBeanOfType(endpoint.getJndiConnectionFactoryName(), ConnectionFactory.class)) != null) {
                jmsConfig.setConnectionFactory(cf);
            }
        }
        boolean resolveUsingJndi = endpoint.getJmsVariant().contains("jndi");
        if (resolveUsingJndi) {
            JndiHelper jt = new JndiHelper(JMSConfigFactory.getInitialContextEnv(endpoint));
            JMSDestinationResolver jndiDestinationResolver = new JMSDestinationResolver();
            jndiDestinationResolver.setJndiTemplate(jt);
            jmsConfig.setDestinationResolver(jndiDestinationResolver);
            jmsConfig.setTargetDestination(endpoint.getDestinationName());
            JMSConfigFactory.setReplyDestination(jmsConfig, endpoint);
        } else {
            jmsConfig.setTargetDestination(endpoint.getDestinationName());
            JMSConfigFactory.setReplyDestination(jmsConfig, endpoint);
        }
        String requestURI = endpoint.getRequestURI();
        jmsConfig.setRequestURI(requestURI);
        String targetService = endpoint.getTargetService();
        jmsConfig.setTargetService(targetService);
        return jmsConfig;
    }

    private static void setReplyDestination(JMSConfiguration jmsConfig, JMSEndpoint endpoint) {
        if (endpoint.getReplyToName() != null) {
            jmsConfig.setReplyDestination(endpoint.getReplyToName());
            jmsConfig.setReplyPubSubDomain(false);
        } else if (endpoint.getTopicReplyToName() != null) {
            jmsConfig.setReplyDestination(endpoint.getTopicReplyToName());
            jmsConfig.setReplyPubSubDomain(true);
        }
    }

    public static Properties getInitialContextEnv(JMSEndpoint endpoint) {
        Properties env = new Properties();
        if (endpoint.getJndiInitialContextFactory() != null) {
            env.put("java.naming.factory.initial", endpoint.getJndiInitialContextFactory());
        }
        if (endpoint.getJndiURL() != null) {
            env.put("java.naming.provider.url", endpoint.getJndiURL());
        }
        for (Map.Entry<String, String> ent : endpoint.getJndiParameters().entrySet()) {
            env.put(ent.getKey(), ent.getValue());
        }
        if (LOG.isLoggable(Level.FINE)) {
            Enumeration<?> props = env.propertyNames();
            while (props.hasMoreElements()) {
                String name = (String)props.nextElement();
                String value = env.getProperty(name);
                LOG.log(Level.FINE, "Context property: " + name + " | " + value);
            }
        }
        return env;
    }
}

