/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.feature;

import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.ws.rm.RMCaptureInInterceptor;
import org.apache.cxf.ws.rm.RMCaptureOutInterceptor;
import org.apache.cxf.ws.rm.RMDeliveryInterceptor;
import org.apache.cxf.ws.rm.RMInInterceptor;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMOutInterceptor;
import org.apache.cxf.ws.rm.manager.DeliveryAssuranceType;
import org.apache.cxf.ws.rm.manager.DestinationPolicyType;
import org.apache.cxf.ws.rm.manager.RM10AddressingNamespaceType;
import org.apache.cxf.ws.rm.manager.SourcePolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.soap.RMSoapInInterceptor;
import org.apache.cxf.ws.rm.soap.RMSoapOutInterceptor;
import org.apache.cxf.ws.rmp.v200502.RMAssertion;

@NoJSR250Annotations
public class RMFeature
extends AbstractFeature {
    private RMAssertion rmAssertion;
    private DeliveryAssuranceType deliveryAssurance;
    private SourcePolicyType sourcePolicy;
    private DestinationPolicyType destinationPolicy;
    private String rmNamespace;
    private RM10AddressingNamespaceType rm10AddressingNamespace;
    private RMStore store;
    private RMInInterceptor rmLogicalIn = new RMInInterceptor();
    private RMOutInterceptor rmLogicalOut = new RMOutInterceptor();
    private RMDeliveryInterceptor rmDelivery = new RMDeliveryInterceptor();
    private RMSoapOutInterceptor rmOutCodec = new RMSoapOutInterceptor();
    private RMSoapInInterceptor rmInCodec = new RMSoapInInterceptor();
    private RMCaptureInInterceptor rmCaptureIn = new RMCaptureInInterceptor();
    private RMCaptureOutInterceptor rmCaptureOut = new RMCaptureOutInterceptor();

    public void setDeliveryAssurance(DeliveryAssuranceType da) {
        this.deliveryAssurance = da;
    }

    public void setDestinationPolicy(DestinationPolicyType dp) {
        this.destinationPolicy = dp;
    }

    public void setRMAssertion(RMAssertion rma) {
        this.rmAssertion = rma;
    }

    public void setSourcePolicy(SourcePolicyType sp) {
        this.sourcePolicy = sp;
    }

    public void setStore(RMStore store) {
        this.store = store;
    }

    public void setRMNamespace(String uri) {
        this.rmNamespace = uri;
    }

    public void setRM10AddressingNamespace(RM10AddressingNamespaceType addrns) {
        this.rm10AddressingNamespace = addrns;
    }

    @Override
    protected void initializeProvider(InterceptorProvider provider, Bus bus) {
        RMManager manager = bus.getExtension(RMManager.class);
        if (null != this.rmAssertion) {
            manager.setRMAssertion(this.rmAssertion);
        }
        if (null != this.deliveryAssurance) {
            manager.setDeliveryAssurance(this.deliveryAssurance);
        }
        if (null != this.sourcePolicy) {
            manager.setSourcePolicy(this.sourcePolicy);
        }
        if (null != this.destinationPolicy) {
            manager.setDestinationPolicy(this.destinationPolicy);
        }
        if (null != this.store) {
            manager.setStore(this.store);
        }
        if (null != this.rmNamespace) {
            manager.getConfiguration().setRMNamespace(this.rmNamespace);
        }
        if (null != this.rm10AddressingNamespace) {
            manager.getConfiguration().setRM10AddressingNamespace(this.rm10AddressingNamespace.getUri());
        }
        this.rmLogicalIn.setBus(bus);
        this.rmLogicalOut.setBus(bus);
        this.rmDelivery.setBus(bus);
        this.rmCaptureIn.setBus(bus);
        this.rmCaptureOut.setBus(bus);
        provider.getInInterceptors().add(this.rmLogicalIn);
        provider.getInInterceptors().add(this.rmInCodec);
        provider.getInInterceptors().add(this.rmDelivery);
        if (null != this.store) {
            provider.getInInterceptors().add(this.rmCaptureIn);
        }
        provider.getOutInterceptors().add(this.rmLogicalOut);
        provider.getOutInterceptors().add(this.rmOutCodec);
        provider.getOutInterceptors().add(this.rmCaptureOut);
        provider.getInFaultInterceptors().add(this.rmLogicalIn);
        provider.getInFaultInterceptors().add(this.rmInCodec);
        provider.getInFaultInterceptors().add(this.rmDelivery);
        provider.getOutFaultInterceptors().add(this.rmLogicalOut);
        provider.getOutFaultInterceptors().add(this.rmOutCodec);
        provider.getOutFaultInterceptors().add(this.rmCaptureOut);
    }
}

