/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.JasyptPasswordEncryptor;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;

public abstract class AbstractWSS4JStaxInterceptor
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private static final Logger LOG;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Map<String, Crypto> cryptos = new ConcurrentHashMap<String, Crypto>();
    private WSSSecurityProperties userSecurityProperties;
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String phase;
    private String id = this.getClass().getName();

    public AbstractWSS4JStaxInterceptor(WSSSecurityProperties securityProperties) {
        this.userSecurityProperties = securityProperties;
    }

    public AbstractWSS4JStaxInterceptor(Map<String, Object> properties) {
        this.properties = properties;
    }

    public AbstractWSS4JStaxInterceptor() {
    }

    protected WSSSecurityProperties createSecurityProperties() {
        if (this.userSecurityProperties != null) {
            return new WSSSecurityProperties(this.userSecurityProperties);
        }
        WSSSecurityProperties securityProperties = new WSSSecurityProperties();
        ConfigurationConverter.parseActions(this.properties, (WSSSecurityProperties)securityProperties);
        ConfigurationConverter.parseUserProperties(this.properties, (WSSSecurityProperties)securityProperties);
        ConfigurationConverter.parseCallback(this.properties, (WSSSecurityProperties)securityProperties);
        ConfigurationConverter.parseBooleanProperties(this.properties, (WSSSecurityProperties)securityProperties);
        ConfigurationConverter.parseNonBooleanProperties(this.properties, (WSSSecurityProperties)securityProperties);
        return securityProperties;
    }

    protected void translateProperties(SoapMessage msg, WSSSecurityProperties securityProperties) {
        String actor;
        String validateSAMLSubjectConf;
        String certConstraints;
        String utTTL;
        String utFutureTTL;
        String ttl;
        String futureTTL;
        String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
        if (bspCompliant != null) {
            securityProperties.setDisableBSPEnforcement(Boolean.valueOf(bspCompliant) == false);
        }
        if ((futureTTL = (String)msg.getContextualProperty("ws-security.timestamp.futureTimeToLive")) != null) {
            securityProperties.setTimeStampFutureTTL(Integer.valueOf(Integer.parseInt(futureTTL)));
        }
        if ((ttl = (String)msg.getContextualProperty("ws-security.timestamp.timeToLive")) != null) {
            securityProperties.setTimestampTTL(Integer.valueOf(Integer.parseInt(ttl)));
        }
        if ((utFutureTTL = (String)msg.getContextualProperty("ws-security.usernametoken.futureTimeToLive")) != null) {
            securityProperties.setUtFutureTTL(Integer.valueOf(Integer.parseInt(utFutureTTL)));
        }
        if ((utTTL = (String)msg.getContextualProperty("ws-security.usernametoken.timeToLive")) != null) {
            securityProperties.setUtTTL(Integer.valueOf(Integer.parseInt(utTTL)));
        }
        if ((certConstraints = (String)msg.getContextualProperty("ws-security.subject.cert.constraints")) != null && !"".equals(certConstraints)) {
            securityProperties.setSubjectCertConstraints(this.convertCertConstraints(certConstraints));
        }
        if ((validateSAMLSubjectConf = (String)msg.getContextualProperty("ws-security.validate.saml.subject.conf")) != null) {
            securityProperties.setValidateSamlSubjectConfirmation(Boolean.valueOf(validateSAMLSubjectConf).booleanValue());
        }
        if ((actor = (String)msg.getContextualProperty("ws-security.actor")) != null) {
            securityProperties.setActor(actor);
        }
        boolean mustUnderstand = MessageUtils.getContextualBoolean(msg, "ws-security.must-understand", true);
        securityProperties.setMustUnderstand(mustUnderstand);
    }

    private Collection<Pattern> convertCertConstraints(String certConstraints) {
        String[] certConstraintsList = certConstraints.split(",");
        if (certConstraintsList != null) {
            ArrayList<Pattern> subjectCertConstraints = new ArrayList<Pattern>(certConstraintsList.length);
            for (String certConstraint : certConstraintsList) {
                try {
                    subjectCertConstraints.add(Pattern.compile(certConstraint.trim()));
                }
                catch (PatternSyntaxException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            return subjectCertConstraints;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void configureCallbackHandler(SoapMessage soapMessage, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object o = soapMessage.getContextualProperty("ws-security.callback-handler");
        if (o instanceof String) {
            try {
                o = ClassLoaderUtils.loadClass((String)o, this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
            }
            if (o instanceof CallbackHandler) {
                EndpointInfo info;
                EndpointInfo endpointInfo = info = soapMessage.getExchange().get(Endpoint.class).getEndpointInfo();
                synchronized (endpointInfo) {
                    info.setProperty("ws-security.callback-handler", o);
                }
            }
        }
        if (o == null && this.getPassword(soapMessage) != null) {
            final String password = this.getPassword(soapMessage);
            o = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (!(callback instanceof WSPasswordCallback)) continue;
                        WSPasswordCallback wsPasswordCallback = (WSPasswordCallback)callback;
                        wsPasswordCallback.setPassword(password);
                    }
                }
            };
        }
        if (o instanceof CallbackHandler) {
            securityProperties.setCallbackHandler((CallbackHandler)o);
        }
    }

    @Override
    public Set<URI> getRoles() {
        return null;
    }

    @Override
    public void handleFault(SoapMessage message) {
    }

    public void postHandleMessage(SoapMessage message) throws Fault {
    }

    @Override
    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Message)msgContext).getContextualProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        Object obj = ((Message)msgContext).getContextualProperty(key);
        if (obj == null) {
            obj = this.getOption(key);
        }
        return obj;
    }

    public void setPassword(Object msgContext, String password) {
        ((Message)msgContext).put("password", password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Message)msgContext).put(key, value);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    @Override
    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    protected boolean isRequestor(SoapMessage message) {
        return MessageUtils.isRequestor(message);
    }

    protected Crypto loadCrypto(SoapMessage soapMessage, String cryptoPropertyFile, String cryptoPropertyRefId, WSSSecurityProperties securityProperties) throws WSSecurityException {
        String propFile;
        Crypto crypto = null;
        String refId = (String)this.getProperty(soapMessage, cryptoPropertyRefId);
        if (refId != null) {
            crypto = this.cryptos.get(refId);
            if (crypto == null) {
                Object obj = this.getProperty(soapMessage, refId);
                if (obj instanceof Properties) {
                    crypto = CryptoFactory.getInstance((Properties)((Properties)obj), (ClassLoader)this.getClassLoader(), (PasswordEncryptor)this.getPasswordEncryptor(soapMessage, securityProperties));
                    this.cryptos.put(refId, crypto);
                } else if (obj instanceof Crypto) {
                    crypto = (Crypto)obj;
                    this.cryptos.put(refId, crypto);
                }
            }
            if (crypto == null) {
                LOG.info("The Crypto reference " + refId + " specified by " + cryptoPropertyRefId + " could not be loaded");
            }
        }
        if (crypto == null && (propFile = (String)this.getProperty(soapMessage, cryptoPropertyFile)) != null) {
            crypto = this.cryptos.get(propFile);
            if (crypto == null) {
                crypto = this.loadCryptoFromPropertiesFile(soapMessage, propFile, securityProperties);
                this.cryptos.put(propFile, crypto);
            }
            if (crypto == null) {
                LOG.info("The Crypto properties file " + propFile + " specified by " + cryptoPropertyFile + " could not be loaded or found");
            }
        }
        return crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Crypto loadCryptoFromPropertiesFile(SoapMessage soapMessage, String propFilename, WSSSecurityProperties securityProperties) throws WSSecurityException {
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource(propFilename, this.getClass());
            if (url == null) {
                ResourceManager manager = soapMessage.getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader(loader);
                }
                url = manager.resolveResource(propFilename, URL.class);
            }
            if (url == null) return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader());
            Properties props = new Properties();
            InputStream in = url.openStream();
            props.load(in);
            in.close();
            Crypto crypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)this.getClassLoader(), (PasswordEncryptor)this.getPasswordEncryptor(soapMessage, securityProperties));
            if (orig == null) return crypto;
            orig.reset();
            return crypto;
        }
        catch (Exception e) {
            // empty catch block
            return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader());
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    protected PasswordEncryptor getPasswordEncryptor(SoapMessage soapMessage, WSSSecurityProperties securityProperties) {
        PasswordEncryptor passwordEncryptor = (PasswordEncryptor)soapMessage.getContextualProperty("ws-security.password.encryptor.instance");
        if (passwordEncryptor != null) {
            return passwordEncryptor;
        }
        CallbackHandler callbackHandler = securityProperties.getCallbackHandler();
        if (callbackHandler == null) {
            callbackHandler = (CallbackHandler)this.getProperties().get("passwordCallbackRef");
        }
        if (callbackHandler != null) {
            return new JasyptPasswordEncryptor(callbackHandler);
        }
        return null;
    }

    protected Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get(new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get(new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }

    private static Properties getProps(Object o, URL propsURL, SoapMessage message) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (propsURL != null) {
            try {
                properties = new Properties();
                InputStream ins = propsURL.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        return properties;
    }

    private URL getPropertiesFileURL(Object o, SoapMessage message) {
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = message.getExchange().get(Bus.class).getExtension(ResourceManager.class);
            url = rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)o, AbstractWSS4JInterceptor.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Crypto getEncryptionCrypto(Object e, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto encrCrypto = null;
        if (e instanceof Crypto) {
            encrCrypto = (Crypto)e;
        } else if (e != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(e, message);
            Properties props = AbstractWSS4JStaxInterceptor.getProps(e, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Encryption properties: " + e);
                Exception ex = new Exception("Cannot find Crypto Encryption properties: " + e);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            encrCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.encryption.crypto", encrCrypto);
            }
        }
        return encrCrypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Crypto getSignatureCrypto(Object s, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto signCrypto = null;
        if (s instanceof Crypto) {
            signCrypto = (Crypto)s;
        } else if (s != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(s, message);
            Properties props = AbstractWSS4JStaxInterceptor.getProps(s, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Signature properties: " + s);
                Exception ex = new Exception("Cannot find Crypto Signature properties: " + s);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            signCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = message.getExchange().get(Endpoint.class).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.signature.crypto", signCrypto);
            }
        }
        return signCrypto;
    }

    private ClassLoader getClassLoader() {
        try {
            return Loader.getTCL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
        LOG = LogUtils.getL7dLogger(AbstractWSS4JStaxInterceptor.class);
    }
}

