/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JStaxInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.cxf.ws.security.wss4j.StaxActionInInterceptor;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.WSSec;
import org.apache.wss4j.stax.ext.InboundWSSec;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.validate.Validator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;

public class WSS4JStaxInInterceptor
extends AbstractWSS4JStaxInterceptor {
    public static final String SECURITY_PROCESSED = WSS4JStaxInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JStaxInInterceptor.class);

    public WSS4JStaxInInterceptor(WSSSecurityProperties securityProperties) {
        super(securityProperties);
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
    }

    public WSS4JStaxInInterceptor(Map<String, Object> props) {
        super(props);
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
    }

    public WSS4JStaxInInterceptor() {
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
    }

    public final boolean isGET(SoapMessage message) {
        String method = (String)message.get("org.apache.cxf.request.method");
        return "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
    }

    @Override
    public void handleMessage(SoapMessage soapMessage) throws Fault {
        if (soapMessage.containsKey(SECURITY_PROCESSED) || this.isGET(soapMessage)) {
            return;
        }
        XMLStreamReader originalXmlStreamReader = soapMessage.getContent(XMLStreamReader.class);
        soapMessage.getInterceptorChain().add(new StaxSecurityContextInInterceptor());
        try {
            List requestSecurityEvents = (List)soapMessage.getExchange().get(SecurityEvent.class.getName() + ".out");
            WSSSecurityProperties secProps = this.createSecurityProperties();
            this.translateProperties(soapMessage, secProps);
            this.configureCallbackHandler(soapMessage, secProps);
            this.configureProperties(soapMessage, secProps);
            if (secProps.getActions() != null && secProps.getActions().size() > 0) {
                soapMessage.getInterceptorChain().add(new StaxActionInInterceptor(secProps.getActions()));
            }
            if (secProps.getAttachmentCallbackHandler() == null) {
                secProps.setAttachmentCallbackHandler((CallbackHandler)new AttachmentCallbackHandler(soapMessage));
            }
            TokenStoreCallbackHandler callbackHandler = new TokenStoreCallbackHandler(secProps.getCallbackHandler(), WSS4JUtils.getTokenStore(soapMessage));
            secProps.setCallbackHandler((CallbackHandler)callbackHandler);
            this.setTokenValidators(secProps, soapMessage);
            secProps.setMsgContext((Object)soapMessage);
            List<SecurityEventListener> securityEventListeners = this.configureSecurityEventListeners(soapMessage, secProps);
            InboundWSSec inboundWSSec = WSSec.getInboundWSSec((WSSSecurityProperties)secProps, (boolean)MessageUtils.isRequestor(soapMessage));
            XMLStreamReader newXmlStreamReader = inboundWSSec.processInMessage(originalXmlStreamReader, requestSecurityEvents, securityEventListeners);
            soapMessage.setContent(XMLStreamReader.class, newXmlStreamReader);
            soapMessage.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        }
        catch (WSSecurityException e) {
            throw this.createSoapFault(soapMessage.getVersion(), e);
        }
        catch (XMLSecurityException e) {
            throw new SoapFault(new Message("STAX_EX", LOG, new Object[0]), (Throwable)e, soapMessage.getVersion().getSender());
        }
        catch (WSSPolicyException e) {
            throw new SoapFault(e.getMessage(), (Throwable)e, soapMessage.getVersion().getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new Message("STAX_EX", LOG, new Object[0]), (Throwable)e, soapMessage.getVersion().getSender());
        }
    }

    protected List<SecurityEventListener> configureSecurityEventListeners(SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        final LinkedList incomingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws WSSecurityException {
                incomingSecurityEventList.add(securityEvent);
            }
        };
        msg.getExchange().put(SecurityEvent.class.getName() + ".in", incomingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".in", (Object)incomingSecurityEventList);
        return Collections.singletonList(securityEventListener);
    }

    protected void configureProperties(SoapMessage msg, WSSSecurityProperties securityProperties) throws XMLSecurityException {
        ReplayCache nonceCache = null;
        if (this.isNonceCacheRequired(msg, securityProperties)) {
            nonceCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
        }
        if (nonceCache == null) {
            securityProperties.setEnableNonceReplayCache(false);
            securityProperties.setNonceReplayCache(null);
        } else {
            securityProperties.setEnableNonceReplayCache(true);
            securityProperties.setNonceReplayCache(nonceCache);
        }
        ReplayCache timestampCache = null;
        if (this.isTimestampCacheRequired(msg, securityProperties)) {
            timestampCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.timestamp.cache", "ws-security.timestamp.cache.instance");
        }
        if (timestampCache == null) {
            securityProperties.setEnableTimestampReplayCache(false);
            securityProperties.setTimestampReplayCache(null);
        } else {
            securityProperties.setEnableTimestampReplayCache(true);
            securityProperties.setTimestampReplayCache(timestampCache);
        }
        ReplayCache samlCache = null;
        if (this.isSamlCacheRequired(msg, securityProperties)) {
            samlCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.saml.cache", "ws-security.saml.cache.instance");
        }
        if (samlCache == null) {
            securityProperties.setEnableSamlOneTimeUseReplayCache(false);
            securityProperties.setSamlOneTimeUseReplayCache(null);
        } else {
            securityProperties.setEnableSamlOneTimeUseReplayCache(true);
            securityProperties.setSamlOneTimeUseReplayCache(samlCache);
        }
        boolean enableRevocation = MessageUtils.isTrue(msg.getContextualProperty("ws-security.enableRevocation"));
        securityProperties.setEnableRevocation(enableRevocation);
        Map<String, Object> config = this.getProperties();
        if (config != null) {
            Crypto decCrypto;
            Crypto sigVerCrypto = this.loadCrypto(msg, "signatureVerificationPropFile", "signatureVerificationPropRefId", securityProperties);
            if (sigVerCrypto == null) {
                sigVerCrypto = this.loadCrypto(msg, "signaturePropFile", "signaturePropRefId", securityProperties);
            }
            if (sigVerCrypto != null) {
                config.put("signatureVerificationPropRefId", "RefId-" + sigVerCrypto.hashCode());
                config.put("RefId-" + sigVerCrypto.hashCode(), sigVerCrypto);
            }
            if ((decCrypto = this.loadCrypto(msg, "decryptionPropFile", "decryptionPropRefId", securityProperties)) != null) {
                config.put("decryptionPropRefId", "RefId-" + decCrypto.hashCode());
                config.put("RefId-" + decCrypto.hashCode(), decCrypto);
            }
            ConfigurationConverter.parseCrypto(config, (WSSSecurityProperties)securityProperties);
        }
    }

    protected boolean isNonceCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        if (securityProperties != null && securityProperties.getActions() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getActions()) {
                if (action != WSSConstants.USERNAMETOKEN) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isTimestampCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        if (securityProperties != null && securityProperties.getActions() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getActions()) {
                if (action != WSSConstants.TIMESTAMP) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isSamlCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        if (securityProperties != null && securityProperties.getActions() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getActions()) {
                if (action != WSSConstants.SAML_TOKEN_UNSIGNED && action != WSSConstants.SAML_TOKEN_SIGNED) continue;
                return true;
            }
        }
        return false;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }

    private void setTokenValidators(WSSSecurityProperties properties, SoapMessage message) throws WSSecurityException {
        Validator validator = this.loadValidator("ws-security.saml1.validator", message);
        if (validator != null) {
            properties.addValidator(WSSConstants.TAG_saml_Assertion, validator);
        }
        if ((validator = this.loadValidator("ws-security.saml2.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_saml2_Assertion, validator);
        }
        if ((validator = this.loadValidator("ws-security.ut.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsse_UsernameToken, validator);
        }
        if ((validator = this.loadValidator("ws-security.signature.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_dsig_Signature, validator);
        }
        if ((validator = this.loadValidator("ws-security.timestamp.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsu_Timestamp, validator);
        }
        if ((validator = this.loadValidator("ws-security.bst.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsse_BinarySecurityToken, validator);
        }
        if ((validator = this.loadValidator("ws-security.sct.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsc0502_SecurityContextToken, validator);
            properties.addValidator(WSSConstants.TAG_wsc0512_SecurityContextToken, validator);
        }
    }

    private Validator loadValidator(String validatorKey, SoapMessage message) throws WSSecurityException {
        Object o = message.getContextualProperty(validatorKey);
        try {
            if (o instanceof Validator) {
                return (Validator)o;
            }
            if (o instanceof Class) {
                return (Validator)((Class)o).newInstance();
            }
            if (o instanceof String) {
                return (Validator)ClassLoaderUtils.loadClass(o.toString(), WSS4JStaxInInterceptor.class).newInstance();
            }
            if (o != null) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Cannot load Validator: " + o, new Object[0]);
            }
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
        return null;
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc;
                String id;
                SecurityToken tok;
                if (!(callbacks[i] instanceof WSPasswordCallback) || (tok = this.store.getToken(id = (pc = (WSPasswordCallback)callbacks[i]).getIdentifier())) == null) continue;
                pc.setKey(tok.getSecret());
                pc.setKey(tok.getKey());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

