/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin.corba.maven.plugins;

import java.io.File;
import java.util.ArrayList;
import org.apache.cxf.maven_plugin.corba.maven.plugins.IdltowsdlOption;
import org.apache.cxf.tools.corba.IDLToWSDL;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class IDLToWSDLPlugin
extends AbstractMojo {
    String outputDir;
    IdltowsdlOption[] idltowsdlOptions;

    public void execute() throws MojoExecutionException {
        System.setProperty("org.apache.cxf.JDKBugHacks.defaultUsesCaches", "true");
        File outputDirFile = new File(this.outputDir);
        outputDirFile.mkdirs();
        if (this.idltowsdlOptions == null) {
            throw new MojoExecutionException("Please specify the idl2wsdl options");
        }
        for (int x = 0; x < this.idltowsdlOptions.length; ++x) {
            boolean doWork;
            File file = new File(this.idltowsdlOptions[x].getIDL());
            File doneFile = new File(outputDirFile, "." + file.getName() + ".DONE");
            boolean bl = doWork = file.lastModified() > doneFile.lastModified();
            if (!doneFile.exists()) {
                doWork = true;
            } else if (file.lastModified() > doneFile.lastModified()) {
                doWork = true;
            }
            if (!doWork) continue;
            ArrayList<String> list = new ArrayList<String>();
            list.add("-o");
            list.add(this.outputDir);
            list.addAll(this.idltowsdlOptions[x].getExtraargs());
            list.add(this.idltowsdlOptions[x].getIDL());
            try {
                IDLToWSDL.run((String[])list.toArray(new String[0]));
                doneFile.delete();
                doneFile.createNewFile();
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

