/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.databinding.stax;

import java.util.List;
import org.apache.cxf.Bus;
import org.apache.cxf.databinding.stax.StaxDataBindingInterceptor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.BareInInterceptor;
import org.apache.cxf.interceptor.DocLiteralInInterceptor;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.WrappedInInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaxDataBindingFeature
extends AbstractFeature {
    public void initialize(Client client, Bus bus) {
        this.removeDatabindingInterceptor(client.getEndpoint().getBinding().getInInterceptors());
    }

    public void initialize(Server server, Bus bus) {
        this.removeDatabindingInterceptor(server.getEndpoint().getBinding().getInInterceptors());
    }

    private void removeDatabindingInterceptor(List<Interceptor> inInterceptors) {
        this.removeInterceptor(inInterceptors, DocLiteralInInterceptor.class.getName());
        this.removeInterceptor(inInterceptors, BareInInterceptor.class.getName());
        this.removeInterceptor(inInterceptors, WrappedInInterceptor.class.getName());
        inInterceptors.add((Interceptor)new StaxDataBindingInterceptor());
    }

    private void removeInterceptor(List<Interceptor> inInterceptors, String name) {
        for (Interceptor i : inInterceptors) {
            PhaseInterceptor p;
            if (!(i instanceof PhaseInterceptor) || !(p = (PhaseInterceptor)i).getId().equals(name)) continue;
            inInterceptors.remove(p);
            return;
        }
    }
}

