/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.interceptor;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.XMLEvent;
import javax.xml.validation.Schema;
import org.apache.cxf.databinding.DataWriter;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.CachingXmlEventWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOutDatabindingInterceptor
extends AbstractPhaseInterceptor<Message> {
    public static final String DISABLE_OUTPUTSTREAM_OPTIMIZATION = "disable.outputstream.optimization";
    public static final String OUT_BUFFERING = "org.apache.cxf.output.buffering";

    public AbstractOutDatabindingInterceptor(String phase) {
        super(phase);
    }

    public AbstractOutDatabindingInterceptor(String id, String phase) {
        super(id, phase);
    }

    protected boolean isRequestor(Message message) {
        return Boolean.TRUE.equals(message.containsKey((Object)"org.apache.cxf.client"));
    }

    protected void writeParts(Message message, Exchange exchange, BindingOperationInfo operation, MessageContentsList objs, List<MessagePartInfo> parts) {
        Object o;
        OutputStream out = (OutputStream)message.getContent(OutputStream.class);
        XMLStreamWriter origXmlWriter = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        Service service = (Service)exchange.get(Service.class);
        XMLStreamWriter xmlWriter = origXmlWriter;
        CachingXmlEventWriter cache = null;
        Object en = message.getContextualProperty(OUT_BUFFERING);
        boolean allowBuffer = true;
        boolean buffer = false;
        if (en != null) {
            buffer = Boolean.TRUE.equals(en) || "true".equals(en);
            boolean bl = allowBuffer = !Boolean.FALSE.equals(en) && !"false".equals(en);
        }
        if (buffer || allowBuffer && this.shouldValidate(message) && !this.isRequestor(message)) {
            cache = new CachingXmlEventWriter();
            try {
                cache.setNamespaceContext(origXmlWriter.getNamespaceContext());
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            xmlWriter = cache;
            out = null;
        }
        if (out != null && this.writeToOutputStream(message, operation.getBinding(), service) && !MessageUtils.isTrue((Object)message.getContextualProperty(DISABLE_OUTPUTSTREAM_OPTIMIZATION))) {
            if (xmlWriter != null) {
                try {
                    xmlWriter.writeCharacters("");
                    xmlWriter.flush();
                }
                catch (XMLStreamException e) {
                    throw new Fault((Throwable)e);
                }
            }
            DataWriter<OutputStream> osWriter = this.getDataWriter(message, service, OutputStream.class);
            for (MessagePartInfo part : parts) {
                if (!objs.hasValue(part)) continue;
                o = objs.get(part);
                osWriter.write(o, part, (Object)out);
            }
        } else {
            DataWriter<XMLStreamWriter> dataWriter = this.getDataWriter(message, service, XMLStreamWriter.class);
            for (MessagePartInfo part : parts) {
                if (!objs.hasValue(part)) continue;
                o = objs.get(part);
                dataWriter.write(o, part, (Object)xmlWriter);
            }
        }
        if (cache != null) {
            try {
                for (XMLEvent event : cache.getEvents()) {
                    StaxUtils.writeEvent((XMLEvent)event, (XMLStreamWriter)origXmlWriter);
                }
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
        }
    }

    protected boolean shouldValidate(Message m) {
        Object en = m.getContextualProperty("schema-validation-enabled");
        return Boolean.TRUE.equals(en) || "true".equals(en);
    }

    protected boolean writeToOutputStream(Message m, BindingInfo info, Service s) {
        if (s == null) {
            return false;
        }
        String enc = (String)m.get((Object)Message.ENCODING);
        return info.getClass().getName().equals("org.apache.cxf.binding.soap.model.SoapBindingInfo") && s.getDataBinding().getClass().getName().equals("org.apache.cxf.jaxb.JAXBDataBinding") && !MessageUtils.isDOMPresent((Message)m) && (enc == null || "UTF-8".equals(enc));
    }

    protected <T> DataWriter<T> getDataWriter(Message message, Service service, Class<T> output) {
        DataWriter writer = service.getDataBinding().createWriter(output);
        ArrayList atts = message.getAttachments();
        if (MessageUtils.isTrue((Object)message.getContextualProperty("mtom-enabled")) && atts == null) {
            atts = new ArrayList();
            message.setAttachments(atts);
        }
        writer.setAttachments((Collection)atts);
        writer.setProperty(DataWriter.ENDPOINT, message.getExchange().get(Endpoint.class));
        writer.setProperty(Message.class.getName(), (Object)message);
        this.setSchemaOutMessage(service, message, writer);
        return writer;
    }

    private void setSchemaOutMessage(Service service, Message message, DataWriter<?> writer) {
        if (this.shouldValidate(message)) {
            Schema schema = EndpointReferenceUtils.getSchema((ServiceInfo)((ServiceInfo)service.getServiceInfos().get(0)));
            writer.setSchema(schema);
        }
    }

    protected XMLStreamWriter getXMLStreamWriter(Message message) {
        return (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
    }
}

