/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.osgi;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;

public class OSGiExtensionLocator
implements BundleActivator,
SynchronousBundleListener {
    private ConcurrentMap<Long, List<Extension>> extensions = new ConcurrentHashMap<Long, List<Extension>>();
    private long id;

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32 && this.id != event.getBundle().getBundleId()) {
            try {
                this.register(event.getBundle());
            }
            catch (Exception exception) {}
        } else if (event.getType() == 64 || event.getType() == 16) {
            this.unregister(event.getBundle().getBundleId());
        }
    }

    public void start(BundleContext context) throws Exception {
        context.addBundleListener((BundleListener)this);
        this.id = context.getBundle().getBundleId();
        for (Bundle bundle : context.getBundles()) {
            if (bundle.getState() != 4 && bundle.getState() != 8 && bundle.getState() != 32 && bundle.getState() != 16 || bundle.getBundleId() == context.getBundle().getBundleId()) continue;
            this.register(bundle);
        }
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        while (!this.extensions.isEmpty()) {
            this.unregister((Long)this.extensions.keySet().iterator().next());
        }
    }

    protected void register(Bundle bundle) throws IOException {
        CopyOnWriteArrayList<Extension> list = (CopyOnWriteArrayList<Extension>)this.extensions.get(bundle.getBundleId());
        Enumeration e = bundle.findEntries("META-INF/cxf/", "bus-extensions.txt", false);
        if (e != null) {
            while (e.hasMoreElements()) {
                URL u = (URL)e.nextElement();
                InputStream ins = u.openStream();
                List<Extension> orig = new ExtensionFragmentParser().getExtensionsFromText(ins);
                ins.close();
                if (orig == null || orig.isEmpty()) continue;
                if (list == null) {
                    list = new CopyOnWriteArrayList<Extension>();
                    this.extensions.put(bundle.getBundleId(), list);
                }
                for (Extension ext : orig) {
                    list.add(new OSGiExtension(ext, bundle));
                }
                ExtensionRegistry.addExtensions(list);
            }
        }
    }

    protected void unregister(long bundleId) {
        List list = (List)this.extensions.remove(bundleId);
        if (list != null) {
            ExtensionRegistry.removeExtensions(list);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class OSGiExtension
    extends Extension {
        final Bundle bundle;

        public OSGiExtension(Extension e, Bundle b) {
            super(e);
            this.bundle = b;
        }

        @Override
        public Class<?> getClassObject(ClassLoader cl) {
            if (this.clazz == null) {
                try {
                    this.clazz = this.bundle.loadClass(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            return super.getClassObject(cl);
        }

        @Override
        public Class<?> loadInterface(ClassLoader cl) {
            try {
                return this.bundle.loadClass(this.interfaceName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return super.loadInterface(cl);
            }
        }
    }
}

