/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.type.AbstractTypeCreator;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.type.basic.BeanType;
import org.apache.cxf.aegis.type.java5.AnnotatedTypeInfo;
import org.apache.cxf.aegis.type.java5.AnnotationReader;
import org.apache.cxf.aegis.type.java5.EnumType;
import org.apache.cxf.aegis.util.NamespaceHelper;
import org.apache.cxf.aegis.util.ServiceUtils;

public class Java5TypeCreator
extends AbstractTypeCreator {
    private AnnotationReader annotationReader;

    public Java5TypeCreator() {
        this(new AnnotationReader());
    }

    public Java5TypeCreator(AnnotationReader annotationReader) {
        this.annotationReader = annotationReader;
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(Method m, int index) {
        AbstractTypeCreator.TypeClassInfo info;
        if (index >= 0) {
            AbstractTypeCreator.TypeClassInfo info2;
            java.lang.reflect.Type genericType = m.getGenericParameterTypes()[index];
            if (genericType instanceof Class) {
                info2 = this.nextCreator.createClassInfo(m, index);
            } else {
                info2 = new AbstractTypeCreator.TypeClassInfo();
                info2.setDescription("method " + m.getName() + " parameter " + index);
                info2.setGenericType(genericType);
            }
            info2.setTypeClass(m.getParameterTypes()[index]);
            info2.setType(this.annotationReader.getParamType(m, index));
            String paramName = this.annotationReader.getParamName(m, index);
            if (paramName != null) {
                info2.setTypeName(this.createQName(m.getParameterTypes()[index], paramName, this.annotationReader.getParamNamespace(m, index)));
            }
            return info2;
        }
        java.lang.reflect.Type genericReturnType = m.getGenericReturnType();
        if (genericReturnType instanceof Class) {
            info = this.nextCreator.createClassInfo(m, index);
        } else {
            info = new AbstractTypeCreator.TypeClassInfo();
            info.setDescription("method " + m.getName() + " parameter " + index);
            info.setGenericType(genericReturnType);
        }
        info.setTypeClass(m.getReturnType());
        if (m.getParameterAnnotations() != null && m.getAnnotations().length > 0) {
            info.setAnnotations(m.getAnnotations());
        }
        info.setType(this.annotationReader.getReturnType(m));
        String returnName = this.annotationReader.getReturnName(m);
        if (returnName != null) {
            info.setTypeName(this.createQName(m.getReturnType(), returnName, this.annotationReader.getReturnNamespace(m)));
        }
        return info;
    }

    public AbstractTypeCreator.TypeClassInfo createClassInfo(PropertyDescriptor pd) {
        AbstractTypeCreator.TypeClassInfo info = this.createBasicClassInfo((Class)pd.getPropertyType());
        info.setGenericType(pd.getReadMethod().getGenericReturnType());
        info.setAnnotations(pd.getReadMethod().getAnnotations());
        info.setType(this.annotationReader.getType(pd.getReadMethod()));
        return info;
    }

    public Type createCollectionType(AbstractTypeCreator.TypeClassInfo info) {
        Object genericType = info.getGenericType();
        Class paramClass = this.getComponentType(genericType, 0);
        if (paramClass != null) {
            return this.createCollectionTypeFromGeneric(info);
        }
        return this.nextCreator.createCollectionType(info);
    }

    protected Type getOrCreateGenericType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 0);
    }

    protected Type getOrCreateMapKeyType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 0);
    }

    protected Type getOrCreateMapValueType(AbstractTypeCreator.TypeClassInfo info) {
        return this.getOrCreateParameterizedType(info.getGenericType(), 1);
    }

    protected Type getOrCreateParameterizedType(Object generic, int index) {
        Class clazz = this.getComponentType(generic, index);
        if (clazz == null) {
            return this.createObjectType();
        }
        if (!Collection.class.isAssignableFrom(clazz)) {
            return this.getTopCreator().createType(clazz);
        }
        Object component = this.getGenericComponent(generic, index);
        AbstractTypeCreator.TypeClassInfo info = this.createBasicClassInfo(clazz);
        info.setDescription(clazz.toString());
        info.setGenericType(component);
        Type type = this.createTypeForClass(info);
        return type;
    }

    private Object getGenericComponent(Object genericType, int index) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            if (type.getActualTypeArguments()[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type.getActualTypeArguments()[index];
                return wildcardType;
            }
            if (type.getActualTypeArguments()[index] instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type.getActualTypeArguments()[index];
                return ptype;
            }
        }
        return null;
    }

    protected Class getComponentType(Object genericType, int index) {
        Class paramClass = null;
        if (genericType instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)genericType;
            if (type.getActualTypeArguments()[index] instanceof Class) {
                paramClass = (Class)type.getActualTypeArguments()[index];
            } else if (type.getActualTypeArguments()[index] instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type.getActualTypeArguments()[index];
                if (wildcardType.getUpperBounds()[0] instanceof Class) {
                    paramClass = (Class)wildcardType.getUpperBounds()[0];
                }
            } else if (type.getActualTypeArguments()[index] instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)type.getActualTypeArguments()[index];
                paramClass = (Class)ptype.getRawType();
            }
        }
        return paramClass;
    }

    public Type createDefaultType(AbstractTypeCreator.TypeClassInfo info) {
        QName typeName = info.getTypeName();
        if (typeName == null) {
            typeName = this.createQName(info.getTypeClass());
        }
        AnnotatedTypeInfo typeInfo = new AnnotatedTypeInfo(this.getTypeMapping(), info.getTypeClass(), typeName.getNamespaceURI(), this.getConfiguration());
        typeInfo.setExtensibleElements(this.annotationReader.isExtensibleElements(info.getTypeClass(), this.getConfiguration().isDefaultExtensibleElements()));
        typeInfo.setExtensibleAttributes(this.annotationReader.isExtensibleAttributes(info.getTypeClass(), this.getConfiguration().isDefaultExtensibleAttributes()));
        typeInfo.setDefaultMinOccurs(this.getConfiguration().getDefaultMinOccurs());
        typeInfo.setDefaultNillable(this.getConfiguration().isDefaultNillable());
        BeanType type = new BeanType(typeInfo);
        type.setTypeMapping(this.getTypeMapping());
        type.setSchemaType(typeName);
        return type;
    }

    public Type createEnumType(AbstractTypeCreator.TypeClassInfo info) {
        EnumType type = new EnumType();
        type.setSchemaType(this.createQName(info.getTypeClass()));
        type.setTypeClass(info.getTypeClass());
        type.setTypeMapping(this.getTypeMapping());
        return type;
    }

    public QName createQName(Class typeClass) {
        String name = this.annotationReader.getName(typeClass);
        String ns = this.annotationReader.getNamespace(typeClass);
        return this.createQName(typeClass, name, ns);
    }

    private QName createQName(Class typeClass, String name, String ns) {
        if (name == null || name.length() == 0) {
            name = ServiceUtils.makeServiceNameFromClassName(typeClass);
        }
        if (ns == null || ns.length() == 0) {
            ns = this.annotationReader.getNamespace(typeClass.getPackage());
        }
        if (ns == null || ns.length() == 0) {
            ns = NamespaceHelper.makeNamespaceFromClassName(typeClass.getName(), "http");
        }
        return new QName(ns, name);
    }

    protected boolean isEnum(Class javaType) {
        return javaType.isEnum();
    }
}

