/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.mtom;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.type.mtom.AbstractXOPType;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Attachment;

public class DataSourceType
extends AbstractXOPType {
    public DataSourceType(boolean useXmimeBinaryType, String expectedContentTypes) {
        super(useXmimeBinaryType, expectedContentTypes);
    }

    protected Object readAttachment(Attachment att, Context context) {
        return att.getDataHandler().getDataSource();
    }

    protected Attachment createAttachment(Object object, String id) {
        DataSource source = (DataSource)object;
        DataHandler handler = new DataHandler(source);
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(true);
        return att;
    }

    protected String getContentType(Object object, Context context) {
        return ((DataSource)object).getContentType();
    }

    protected Object wrapBytes(byte[] bareBytes, String contentType) {
        return new DataHandler((Object)bareBytes, contentType).getDataSource();
    }

    protected byte[] getBytes(Object object) {
        DataSource dataSource = (DataSource)object;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            InputStream stream = dataSource.getInputStream();
            IOUtils.copy((InputStream)stream, (OutputStream)baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return baos.toByteArray();
    }
}

