/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import java.lang.reflect.Type;
import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.apache.cxf.common.xmlschema.XmlSchemaConstants;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaEnumerationFacet;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaType;

public class EnumType
extends AegisType {
    public Object readObject(MessageReader reader, Context context) {
        String value = reader.getValue();
        return Enum.valueOf(this.getTypeClass(), value.trim());
    }

    public void writeObject(Object object, MessageWriter writer, Context context) {
        writer.writeValue(((Enum)object).name());
    }

    public void setTypeClass(Type typeClass) {
        if (!(typeClass instanceof Class)) {
            throw new DatabindingException("Aegis cannot map generic Enums.");
        }
        Class plainClass = (Class)typeClass;
        if (!plainClass.isEnum()) {
            throw new DatabindingException("EnumType must map an enum.");
        }
        super.setTypeClass(typeClass);
    }

    public void writeSchema(XmlSchema root) {
        XmlSchemaSimpleType simple = new XmlSchemaSimpleType(root);
        simple.setName(this.getSchemaType().getLocalPart());
        root.addType((XmlSchemaType)simple);
        root.getItems().add((XmlSchemaObject)simple);
        XmlSchemaSimpleTypeRestriction restriction = new XmlSchemaSimpleTypeRestriction();
        restriction.setBaseTypeName(XmlSchemaConstants.STRING_QNAME);
        simple.setContent((XmlSchemaSimpleTypeContent)restriction);
        T[] constants = this.getTypeClass().getEnumConstants();
        XmlSchemaObjectCollection facets = restriction.getFacets();
        for (Object constant : constants) {
            XmlSchemaEnumerationFacet f = new XmlSchemaEnumerationFacet();
            f.setValue((Object)((Enum)constant).name());
            facets.add((XmlSchemaObject)f);
        }
    }

    public boolean isComplex() {
        return true;
    }
}

