/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.UriBuilderImpl;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.phase.PhaseChainCache;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.transport.MessageObserver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractClient
implements Client,
InvocationHandlerAware {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractClient.class);
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AbstractClient.class);
    protected List<Interceptor> inInterceptors = new ModCountCopyOnWriteArrayList();
    protected List<Interceptor> outInterceptors = new ModCountCopyOnWriteArrayList();
    protected ConduitSelector conduitSelector;
    protected Bus bus;
    private MultivaluedMap<String, String> requestHeaders = new MetadataMap<String, String>();
    private Response.ResponseBuilder responseBuilder;
    private URI baseURI;
    private UriBuilder currentBuilder;

    protected AbstractClient(URI baseURI, URI currentURI) {
        this.baseURI = baseURI;
        this.currentBuilder = new UriBuilderImpl(currentURI);
    }

    @Override
    public Client header(String name, Object ... values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if ("Content-Type".equals(name) && values.length > 1) {
            throw new WebApplicationException();
        }
        for (Object o : values) {
            this.requestHeaders.add((Object)name, (Object)o.toString());
        }
        return this;
    }

    @Override
    public Client headers(MultivaluedMap<String, String> map) {
        this.requestHeaders.putAll(map);
        return this;
    }

    @Override
    public Client accept(MediaType ... types) {
        for (MediaType mt : types) {
            this.requestHeaders.add((Object)"Accept", (Object)mt.toString());
        }
        return this;
    }

    @Override
    public Client type(MediaType ct) {
        return this.type(ct.toString());
    }

    @Override
    public Client type(String type) {
        this.requestHeaders.putSingle((Object)"Content-Type", (Object)type);
        return this;
    }

    @Override
    public Client accept(String ... types) {
        for (String type : types) {
            this.requestHeaders.add((Object)"Accept", (Object)type);
        }
        return this;
    }

    @Override
    public Client cookie(Cookie cookie) {
        this.requestHeaders.add((Object)"Cookie", (Object)cookie.toString());
        return this;
    }

    @Override
    public Client modified(Date date, boolean ifNot) {
        SimpleDateFormat dateFormat = HttpUtils.getHttpDateFormat();
        String hName = ifNot ? "If-Unmodified-Since" : "If-Modified-Since";
        this.requestHeaders.putSingle((Object)hName, (Object)dateFormat.format(date));
        return this;
    }

    @Override
    public Client language(String language) {
        this.requestHeaders.putSingle((Object)"Content-Language", (Object)language);
        return this;
    }

    @Override
    public Client match(EntityTag tag, boolean ifNot) {
        String hName = ifNot ? "If-None-Match" : "If-Match";
        this.requestHeaders.putSingle((Object)hName, (Object)tag.toString());
        return this;
    }

    @Override
    public Client acceptLanguage(String ... languages) {
        for (String s : languages) {
            this.requestHeaders.add((Object)"Accept-Language", (Object)s);
        }
        return this;
    }

    @Override
    public Client acceptEncoding(String ... encs) {
        for (String s : encs) {
            this.requestHeaders.add((Object)"Accept-Encoding", (Object)s);
        }
        return this;
    }

    @Override
    public Client encoding(String enc) {
        this.requestHeaders.putSingle((Object)"Content-Encoding", (Object)enc);
        return this;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        MetadataMap<String, String> map = new MetadataMap<String, String>();
        map.putAll((Map)this.requestHeaders);
        return map;
    }

    @Override
    public URI getBaseURI() {
        return this.baseURI;
    }

    @Override
    public URI getCurrentURI() {
        return this.getCurrentBuilder().clone().buildFromEncoded(new Object[0]);
    }

    @Override
    public Response getResponse() {
        if (this.responseBuilder == null) {
            return null;
        }
        return this.responseBuilder.build();
    }

    @Override
    public Client reset() {
        this.requestHeaders.clear();
        this.resetResponse();
        return this;
    }

    protected List<MediaType> getAccept() {
        List headers = (List)this.requestHeaders.get((Object)"Accept");
        if (headers == null || headers.size() == 0) {
            return null;
        }
        ArrayList<MediaType> types = new ArrayList<MediaType>();
        for (String s : headers) {
            types.add(MediaType.valueOf((String)s));
        }
        return types;
    }

    protected MediaType getType() {
        String type = (String)this.requestHeaders.getFirst((Object)"Content-Type");
        return type == null ? null : MediaType.valueOf((String)type);
    }

    protected UriBuilder getCurrentBuilder() {
        return this.currentBuilder;
    }

    protected void resetResponse() {
        this.responseBuilder = null;
    }

    protected void resetBaseAddress(URI uri) {
        this.baseURI = uri;
        this.resetCurrentBuilder(uri);
    }

    protected void resetCurrentBuilder(URI uri) {
        this.currentBuilder = new UriBuilderImpl(uri);
    }

    protected Response.ResponseBuilder setResponseBuilder(HttpURLConnection conn) throws Throwable {
        if (conn == null) {
            throw new WebApplicationException();
        }
        int status = conn.getResponseCode();
        this.responseBuilder = Response.status((int)status);
        for (Map.Entry<String, List<String>> entry : conn.getHeaderFields().entrySet()) {
            for (String s : entry.getValue()) {
                this.responseBuilder.header(entry.getKey(), (Object)s);
            }
        }
        if (status >= 400) {
            try {
                InputStream errorStream = conn.getErrorStream();
                if (errorStream != null) {
                    this.responseBuilder.entity((Object)IOUtils.readStringFromStream((InputStream)errorStream));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.responseBuilder;
    }

    protected void writeBody(Object o, Message m, Class<?> cls, Type type, Annotation[] anns, MultivaluedMap<String, String> headers, OutputStream os) {
        if (o == null) {
            return;
        }
        MediaType contentType = MediaType.valueOf((String)((String)headers.getFirst((Object)"Content-Type")));
        MessageBodyWriter<?> mbw = ProviderFactory.getInstance(m).createMessageBodyWriter(cls, type, anns, contentType, m);
        if (mbw == null) {
            mbw = ProviderFactory.getInstance().createMessageBodyWriter(cls, type, anns, contentType, m);
        }
        if (mbw != null) {
            try {
                mbw.writeTo(o, cls, type, anns, contentType, headers, os);
                os.flush();
            }
            catch (Exception ex) {
                throw new WebApplicationException();
            }
        } else {
            AbstractClient.reportNoMessageHandler("NO_MSG_WRITER", cls);
        }
    }

    protected Object readBody(Response r, HttpURLConnection conn, Message inMessage, Class<?> cls, Type type, Annotation[] anns) {
        try {
            int status = conn.getResponseCode();
            if (status < 200 || status == 204 || status > 300) {
                return null;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        MediaType contentType = AbstractClient.getResponseContentType(r);
        MessageBodyReader<?> mbr = ProviderFactory.getInstance(inMessage).createMessageBodyReader(cls, type, anns, contentType, inMessage);
        if (mbr == null) {
            ProviderFactory.getInstance().createMessageBodyReader(cls, type, anns, contentType, inMessage);
        }
        if (mbr != null) {
            try {
                return mbr.readFrom(cls, type, anns, contentType, r.getMetadata(), conn.getInputStream());
            }
            catch (Exception ex) {
                throw new WebApplicationException();
            }
        }
        AbstractClient.reportNoMessageHandler("NO_MSG_READER", cls);
        return null;
    }

    protected static void reportNoMessageHandler(String name, Class<?> cls) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, new Object[]{cls});
        LOG.severe(errorMsg.toString());
        throw new WebApplicationException(415);
    }

    private static MediaType getResponseContentType(Response r) {
        MultivaluedMap map = r.getMetadata();
        if (map.containsKey((Object)"Content-Type")) {
            return MediaType.valueOf((String)map.getFirst((Object)"Content-Type").toString());
        }
        return MediaType.WILDCARD_TYPE;
    }

    protected static HttpURLConnection createHttpConnection(URI uri, String methodName) {
        try {
            URL url = uri.toURL();
            HttpURLConnection connect = (HttpURLConnection)url.openConnection();
            connect.setDoOutput(true);
            connect.setRequestMethod(methodName);
            return connect;
        }
        catch (Exception ex) {
            throw new WebApplicationException((Throwable)ex);
        }
    }

    protected static void setAllHeaders(MultivaluedMap<String, String> headers, HttpURLConnection conn) {
        for (Map.Entry entry : headers.entrySet()) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < ((List)entry.getValue()).size(); ++i) {
                String value = (String)((List)entry.getValue()).get(i);
                b.append(value);
                if (i + 1 >= ((List)entry.getValue()).size()) continue;
                b.append(',');
            }
            conn.setRequestProperty((String)entry.getKey(), b.toString());
        }
    }

    protected void setConduitSelector(ConduitSelector cs) {
        this.conduitSelector = cs;
    }

    protected void setBus(Bus bus) {
        this.bus = bus;
    }

    protected void prepareConduitSelector(Message message) {
        this.conduitSelector.prepare(message);
        message.getExchange().put(ConduitSelector.class, (Object)this.conduitSelector);
    }

    protected PhaseInterceptorChain setupOutInterceptorChain(Endpoint endpoint) {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getOutInterceptors();
        List<Interceptor> i2 = this.outInterceptors;
        List i3 = endpoint.getOutInterceptors();
        return new PhaseChainCache().get(pm.getOutPhases(), i1, i2, i3);
    }

    protected PhaseInterceptorChain setupInInterceptorChain(Endpoint endpoint) {
        PhaseManager pm = (PhaseManager)this.bus.getExtension(PhaseManager.class);
        List i1 = this.bus.getInInterceptors();
        List<Interceptor> i2 = this.inInterceptors;
        List i3 = endpoint.getInInterceptors();
        return new PhaseChainCache().get(pm.getInPhases(), i1, i2, i3);
    }

    protected Message createSimpleMessage() {
        MessageImpl m = new MessageImpl();
        m.put((Object)Message.PROTOCOL_HEADERS, this.getHeaders());
        return m;
    }

    protected Message createMessage(String httpMethod, MultivaluedMap<String, String> headers, URI currentURI) {
        Message m = this.conduitSelector.getEndpoint().getBinding().createMessage();
        m.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        m.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.FALSE);
        m.put((Object)Message.HTTP_REQUEST_METHOD, (Object)httpMethod);
        m.put((Object)Message.PROTOCOL_HEADERS, headers);
        m.put((Object)Message.ENDPOINT_ADDRESS, (Object)currentURI.toString());
        m.put((Object)Message.REQUEST_URI, (Object)currentURI.toString());
        m.put((Object)"Content-Type", headers.getFirst((Object)"Content-Type"));
        ExchangeImpl exchange = new ExchangeImpl();
        exchange.setSynchronous(true);
        exchange.setOutMessage(m);
        exchange.put(Bus.class, (Object)this.bus);
        exchange.put(MessageObserver.class, (Object)new ClientMessageObserver());
        exchange.put(Endpoint.class, (Object)this.conduitSelector.getEndpoint());
        exchange.setOneWay(false);
        m.setExchange((Exchange)exchange);
        PhaseInterceptorChain chain = this.setupOutInterceptorChain(this.conduitSelector.getEndpoint());
        m.setInterceptorChain((InterceptorChain)chain);
        this.prepareConduitSelector(m);
        return m;
    }

    protected void setInInterceptors(List<Interceptor> interceptors) {
        this.inInterceptors = interceptors;
    }

    protected void setOutInterceptors(List<Interceptor> interceptors) {
        this.outInterceptors = interceptors;
    }

    @Override
    public Object getInvocationHandler() {
        return this;
    }

    private class ClientMessageObserver
    implements MessageObserver {
        private ClientMessageObserver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message m) {
            Message message = AbstractClient.this.conduitSelector.getEndpoint().getBinding().createMessage(m);
            message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
            message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
            PhaseInterceptorChain chain = AbstractClient.this.setupInInterceptorChain(AbstractClient.this.conduitSelector.getEndpoint());
            message.setInterceptorChain((InterceptorChain)chain);
            Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
            BusFactory.setThreadDefaultBus((Bus)AbstractClient.this.bus);
            try {
                chain.doIntercept(message);
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)origBus);
            }
        }
    }
}

