/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import java.util.Map;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.core.Configurable;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.apache.cxf.jaxrs.impl.ConfigurationImpl;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;

public class ConfigurableImpl<C extends Configurable<C>>
implements Configurable<C> {
    private ConfigurationImpl config;
    private C configurable;
    private Class<?>[] supportedProviderClasses;

    public ConfigurableImpl(C configurable, RuntimeType rt, Class<?>[] supportedProviderClasses) {
        this(configurable, supportedProviderClasses, new ConfigurationImpl(rt));
    }

    public ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses, Configuration config) {
        this(configurable, supportedProviderClasses);
        this.config = config instanceof ConfigurationImpl ? (ConfigurationImpl)config : new ConfigurationImpl(config, supportedProviderClasses);
    }

    private ConfigurableImpl(C configurable, Class<?>[] supportedProviderClasses) {
        this.configurable = configurable;
        this.supportedProviderClasses = supportedProviderClasses;
    }

    protected C getConfigurable() {
        return this.configurable;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public C property(String name, Object value) {
        this.config.setProperty(name, value);
        return this.configurable;
    }

    public C register(Object provider) {
        return this.register(provider, AnnotationUtils.getBindingPriority(provider.getClass()));
    }

    public C register(Object provider, int bindingPriority) {
        return this.doRegister(provider, bindingPriority, this.supportedProviderClasses);
    }

    public C register(Object provider, Class<?> ... contracts) {
        return this.doRegister(provider, 5000, contracts);
    }

    public C register(Object provider, Map<Class<?>, Integer> contracts) {
        if (provider instanceof Feature) {
            Feature feature = (Feature)provider;
            boolean enabled = feature.configure((FeatureContext)new FeatureContextImpl(this));
            this.config.setFeature(feature, enabled);
            return this.configurable;
        }
        this.config.register(provider, contracts);
        return this.configurable;
    }

    public C register(Class<?> providerClass) {
        return this.register(providerClass, AnnotationUtils.getBindingPriority(providerClass));
    }

    public C register(Class<?> providerClass, int bindingPriority) {
        return this.doRegister(ConfigurationImpl.createProvider(providerClass), bindingPriority, this.supportedProviderClasses);
    }

    public C register(Class<?> providerClass, Class<?> ... contracts) {
        return this.doRegister(providerClass, 5000, contracts);
    }

    public C register(Class<?> providerClass, Map<Class<?>, Integer> contracts) {
        return this.register(ConfigurationImpl.createProvider(providerClass), contracts);
    }

    private C doRegister(Object provider, int bindingPriority, Class<?> ... contracts) {
        return this.register(provider, ConfigurationImpl.initContractsMap(bindingPriority, contracts));
    }

    public static class FeatureContextImpl
    implements FeatureContext {
        private Configurable<?> cfg;

        public FeatureContextImpl(Configurable<?> cfg) {
            this.cfg = cfg;
        }

        public Configuration getConfiguration() {
            return this.cfg.getConfiguration();
        }

        public FeatureContext property(String name, Object value) {
            this.cfg.property(name, value);
            return this;
        }

        public FeatureContext register(Class<?> cls) {
            this.cfg.register(cls);
            return this;
        }

        public FeatureContext register(Object obj) {
            this.cfg.register(obj);
            return this;
        }

        public FeatureContext register(Class<?> cls, int priority) {
            this.cfg.register(cls, priority);
            return this;
        }

        public FeatureContext register(Class<?> cls, Class<?> ... contract) {
            this.cfg.register(cls, (Class[])contract);
            return this;
        }

        public FeatureContext register(Class<?> cls, Map<Class<?>, Integer> map) {
            this.cfg.register(cls, map);
            return this;
        }

        public FeatureContext register(Object obj, int priority) {
            this.cfg.register(obj, priority);
            return this;
        }

        public FeatureContext register(Object obj, Class<?> ... contract) {
            this.cfg.register(obj, (Class[])contract);
            return this;
        }

        public FeatureContext register(Object obj, Map<Class<?>, Integer> map) {
            this.cfg.register(obj, map);
            return this;
        }
    }
}

