/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.cxf.annotations.Provider;
import org.apache.cxf.common.util.ClasspathScanner;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.spring.AbstractSpringConfigurationFactory;
import org.apache.cxf.jaxrs.spring.JAXRSServerFactoryBeanDefinitionParser;
import org.apache.cxf.jaxrs.spring.SpringResourceFactory;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;

@ComponentScan(includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={Path.class, javax.ws.rs.ext.Provider.class, Provider.class})})
public abstract class AbstractSpringComponentScanServer
extends AbstractSpringConfigurationFactory {
    @Value(value="${cxf.jaxrs.classes-scan-packages:}")
    private String classesScanPackages;
    private List<ResourceProvider> resourceProviders = new LinkedList<ResourceProvider>();
    private List<Object> jaxrsProviders = new LinkedList<Object>();
    private List<Feature> cxfFeatures = new LinkedList<Feature>();
    private List<Interceptor<? extends Message>> cxfInInterceptors = new LinkedList<Interceptor<? extends Message>>();
    private List<Interceptor<? extends Message>> cxfOutInterceptors = new LinkedList<Interceptor<? extends Message>>();
    private Class<? extends Annotation> serviceAnnotation;

    protected AbstractSpringComponentScanServer() {
    }

    protected AbstractSpringComponentScanServer(Class<? extends Annotation> serviceAnnotation) {
        this.serviceAnnotation = serviceAnnotation;
    }

    @Override
    protected void setJaxrsResources(JAXRSServerFactoryBean factory) {
        boolean checkJaxrsRoots = this.checkJaxrsRoots();
        boolean checkJaxrsProviders = this.checkJaxrsProviders();
        boolean checkCxfProviders = this.checkCxfProviders();
        for (String beanName : this.applicationContext.getBeanDefinitionNames()) {
            if (checkJaxrsRoots && this.isAnnotationAvailable(beanName, Path.class) && this.matchesServiceAnnotation(beanName)) {
                SpringResourceFactory resourceFactory = new SpringResourceFactory(beanName);
                resourceFactory.setApplicationContext(this.applicationContext);
                this.resourceProviders.add(resourceFactory);
                continue;
            }
            if (checkJaxrsProviders && this.isAnnotationAvailable(beanName, javax.ws.rs.ext.Provider.class) && this.matchesServiceAnnotation(beanName)) {
                this.jaxrsProviders.add(this.getProviderBean(beanName));
                continue;
            }
            if (!checkCxfProviders || !this.isAnnotationAvailable(beanName, Provider.class) || !this.matchesServiceAnnotation(beanName)) continue;
            this.addCxfProvider(this.getProviderBean(beanName));
        }
        if (!StringUtils.isEmpty((String)this.classesScanPackages)) {
            try {
                Map classes = ClasspathScanner.findClasses((String)this.classesScanPackages, (Class[])new Class[]{javax.ws.rs.ext.Provider.class, Provider.class});
                this.jaxrsProviders.addAll(JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)classes.get(javax.ws.rs.ext.Provider.class), null));
                List<Object> cxfProviders = JAXRSServerFactoryBeanDefinitionParser.createBeansFromDiscoveredClasses(this.applicationContext, (Collection)classes.get(Provider.class), null);
                for (Object cxfProvider : cxfProviders) {
                    this.addCxfProvider(cxfProvider);
                }
            }
            catch (Exception ex) {
                throw new ServiceConstructionException((Throwable)ex);
            }
        }
        factory.setResourceProviders(this.getResourceProviders());
        factory.setProviders(this.getJaxrsProviders());
        factory.setFeatures(this.getFeatures());
        factory.setInInterceptors(this.getInInterceptors());
        factory.setOutInterceptors(this.getOutInterceptors());
    }

    private Object getProviderBean(String beanName) {
        return this.applicationContext.getBean(beanName);
    }

    protected void addCxfProvider(Object bean) {
        Provider ann = bean.getClass().getAnnotation(Provider.class);
        if (ann.scope() == Provider.Scope.Client) {
            return;
        }
        if (ann.value() == Provider.Type.Feature) {
            this.cxfFeatures.add((Feature)bean);
        } else if (ann.value() == Provider.Type.InInterceptor) {
            this.cxfInInterceptors.add((Interceptor<? extends Message>)((Interceptor)bean));
        } else if (ann.value() == Provider.Type.OutInterceptor) {
            this.cxfOutInterceptors.add((Interceptor<? extends Message>)((Interceptor)bean));
        }
    }

    protected boolean matchesServiceAnnotation(String beanName) {
        return this.serviceAnnotation == null || this.isAnnotationAvailable(beanName, this.serviceAnnotation);
    }

    protected <A extends Annotation> boolean isAnnotationAvailable(String beanName, Class<A> annClass) {
        return this.applicationContext.findAnnotationOnBean(beanName, annClass) != null;
    }

    protected boolean checkCxfProviders() {
        return true;
    }

    protected boolean checkJaxrsProviders() {
        return true;
    }

    protected boolean checkJaxrsRoots() {
        return true;
    }

    protected List<ResourceProvider> getResourceProviders() {
        return this.resourceProviders;
    }

    @Override
    protected List<Object> getJaxrsProviders() {
        return this.jaxrsProviders;
    }

    @Override
    public List<Feature> getFeatures() {
        return this.cxfFeatures;
    }

    public List<Interceptor<? extends Message>> getInInterceptors() {
        return this.cxfInInterceptors;
    }

    public List<Interceptor<? extends Message>> getOutInterceptors() {
        return this.cxfOutInterceptors;
    }
}

