/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.DefaultMethod;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.URITemplate;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;

public class OperationResourceInfoComparator
implements Comparator<OperationResourceInfo> {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXRSUtils.class);
    private String httpMethod;
    private boolean getMethod;
    private Message message;
    private ResourceComparator rc;
    private MediaType contentType = MediaType.WILDCARD_TYPE;
    private List<MediaType> acceptTypes = Collections.singletonList(MediaType.WILDCARD_TYPE);

    public OperationResourceInfoComparator(Message m, String method) {
        Object o;
        this.message = m;
        if (this.message != null && (o = m.getExchange().getEndpoint().get((Object)"org.apache.cxf.jaxrs.comparator")) != null) {
            this.rc = (ResourceComparator)o;
        }
        this.httpMethod = method;
    }

    public OperationResourceInfoComparator(Message m, String httpMethod, boolean getMethod, MediaType contentType, List<MediaType> acceptTypes) {
        this(m, httpMethod);
        this.contentType = contentType;
        this.acceptTypes = acceptTypes;
        this.getMethod = getMethod;
    }

    @Override
    public int compare(OperationResourceInfo e1, OperationResourceInfo e2) {
        int result;
        if (e1 == e2) {
            return 0;
        }
        if (this.rc != null && (result = this.rc.compare(e1, e2, this.message)) != 0) {
            return result;
        }
        String e1HttpMethod = e1.getHttpMethod();
        String e2HttpMethod = e2.getHttpMethod();
        int result2 = 0;
        if (!this.getMethod && "HEAD".equals(this.httpMethod) && (result2 = OperationResourceInfoComparator.compareWithHead(e1HttpMethod, e2HttpMethod)) != 0) {
            return result2;
        }
        result2 = URITemplate.compareTemplates(e1.getURITemplate(), e2.getURITemplate());
        if (result2 == 0 && (e1HttpMethod != null && e2HttpMethod == null || e1HttpMethod == null && e2HttpMethod != null)) {
            return e1.getHttpMethod() != null ? -1 : 1;
        }
        if (result2 == 0 && !this.getMethod) {
            result2 = JAXRSUtils.compareSortedConsumesMediaTypes(e1.getConsumeTypes(), e2.getConsumeTypes(), this.contentType);
        }
        if (result2 == 0) {
            result2 = JAXRSUtils.compareSortedAcceptMediaTypes(e1.getProduceTypes(), e2.getProduceTypes(), this.acceptTypes);
        }
        if (result2 == 0 && e1HttpMethod != null && e2HttpMethod != null) {
            boolean e1IsDefault = DefaultMethod.class.getSimpleName().equals(e1HttpMethod);
            boolean e2IsDefault = DefaultMethod.class.getSimpleName().equals(e2HttpMethod);
            if (e1IsDefault && !e2IsDefault) {
                result2 = 1;
            } else if (!e1IsDefault && e2IsDefault) {
                result2 = -1;
            }
        }
        if (result2 == 0) {
            String m1Name = e1.getClassResourceInfo().getServiceClass().getName() + "#" + e1.getMethodToInvoke().getName();
            String m2Name = e2.getClassResourceInfo().getServiceClass().getName() + "#" + e2.getMethodToInvoke().getName();
            LOG.warning("Both " + m1Name + " and " + m2Name + " are equal candidates for handling the current request which can lead to unpredictable results");
        }
        return result2;
    }

    private static int compareWithHead(String e1HttpMethod, String e2HttpMethod) {
        if ("HEAD".equals(e1HttpMethod)) {
            return -1;
        }
        if ("HEAD".equals(e2HttpMethod)) {
            return 1;
        }
        return 0;
    }
}

