/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.refresh;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.provider.AccessTokenGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class RefreshTokenGrantHandler
implements AccessTokenGrantHandler {
    private OAuthDataProvider dataProvider;
    private boolean partialMatchScopeValidation;
    private boolean useAllClientScopes;

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public List<String> getSupportedGrantTypes() {
        return Collections.singletonList("refresh_token");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        String refreshToken = (String)params.getFirst((Object)"refresh_token");
        List<String> requestedScopes = OAuthUtils.getRequestedScopes(client, (String)params.getFirst((Object)"scope"), this.useAllClientScopes, this.partialMatchScopeValidation);
        ServerAccessToken st = this.dataProvider.refreshAccessToken(client, refreshToken, requestedScopes);
        st.setGrantType("refresh_token");
        return st;
    }

    public void setPartialMatchScopeValidation(boolean partialMatchScopeValidation) {
        this.partialMatchScopeValidation = partialMatchScopeValidation;
    }

    public void setUseAllClientScopes(boolean useAllClientScopes) {
        this.useAllClientScopes = useAllClientScopes;
    }
}

