/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http_jetty;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.continuations.ContinuationInfo;
import org.apache.cxf.continuations.ContinuationProvider;
import org.apache.cxf.continuations.SuspendedInvocationException;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.ExchangeImpl;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.Session;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.HTTPSession;
import org.apache.cxf.transport.http_jetty.JettyHTTPHandler;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngine;
import org.apache.cxf.transport.http_jetty.JettyHTTPServerEngineFactory;
import org.apache.cxf.transport.http_jetty.JettyHTTPTransportFactory;
import org.apache.cxf.transport.http_jetty.ServerEngine;
import org.apache.cxf.transport.http_jetty.continuations.JettyContinuationProvider;
import org.apache.cxf.transports.http.QueryHandler;
import org.apache.cxf.transports.http.QueryHandlerRegistry;
import org.apache.cxf.transports.http.StemMatchingQueryHandler;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.util.ajax.Continuation;
import org.mortbay.util.ajax.ContinuationSupport;

public class JettyHTTPDestination
extends AbstractHTTPDestination {
    private static final Logger LOG = LogUtils.getL7dLogger(JettyHTTPDestination.class);
    protected JettyHTTPServerEngine engine;
    protected JettyHTTPTransportFactory transportFactory;
    protected JettyHTTPServerEngineFactory serverEngineFactory;
    protected ServletContext servletContext;
    protected URL nurl;
    private boolean configFinalized;

    public JettyHTTPDestination(Bus b, JettyHTTPTransportFactory ci, EndpointInfo endpointInfo) throws IOException {
        super(b, (ConduitInitiator)ci, endpointInfo, true);
        this.transportFactory = ci;
        this.serverEngineFactory = ci.getJettyHTTPServerEngineFactory();
        this.nurl = new URL(endpointInfo.getAddress());
    }

    protected Logger getLogger() {
        return LOG;
    }

    public void setServletContext(ServletContext sc) {
        this.servletContext = sc;
    }

    protected void retrieveEngine() throws GeneralSecurityException, IOException {
        this.engine = this.serverEngineFactory.retrieveJettyHTTPServerEngine(this.nurl.getPort());
        if (this.engine == null) {
            this.engine = this.serverEngineFactory.createJettyHTTPServerEngine(this.nurl.getPort(), this.nurl.getProtocol());
        }
        assert (this.engine != null);
        if (!this.nurl.getProtocol().equals(this.engine.getProtocol())) {
            throw new IllegalStateException("Port " + this.engine.getPort() + " is configured with wrong protocol \"" + this.engine.getProtocol() + "\" for \"" + this.nurl + "\"");
        }
    }

    public void finalizeConfig() throws GeneralSecurityException, IOException {
        assert (!this.configFinalized);
        this.retrieveEngine();
        this.configFinalized = true;
    }

    protected void activate() {
        LOG.log(Level.FINE, "Activating receipt of incoming messages");
        URL url = null;
        try {
            url = new URL(this.endpointInfo.getAddress());
        }
        catch (Exception e) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("START_UP_SERVER_FAILED_MSG", LOG, new Object[]{e.getMessage()}), (Throwable)e);
        }
        this.engine.addServant(url, new JettyHTTPHandler(this, this.contextMatchOnExact()));
    }

    protected void deactivate() {
        LOG.log(Level.FINE, "Deactivating receipt of incoming messages");
        this.engine.removeServant(this.nurl);
    }

    protected String getBasePathForFullAddress(String addr) {
        try {
            return new URL(addr).getPath();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private String removeTrailingSeparator(String addr) {
        if (addr != null && addr.length() > 0 && addr.lastIndexOf(47) == addr.length() - 1) {
            return addr.substring(0, addr.length() - 1);
        }
        return addr;
    }

    private synchronized String updateEndpointAddress(String addr) {
        String address = this.removeTrailingSeparator(this.endpointInfo.getAddress());
        if (this.getBasePathForFullAddress(address).equals(this.removeTrailingSeparator(this.getStem(this.getBasePathForFullAddress(addr))))) {
            this.endpointInfo.setAddress(addr);
        }
        return address;
    }

    protected void doService(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doService(this.servletContext, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doService(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        Request baseRequest;
        if (context == null) {
            context = this.servletContext;
        }
        Request request = baseRequest = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
        if (this.getServer().isSetRedirectURL()) {
            resp.sendRedirect(this.getServer().getRedirectURL());
            resp.flushBuffer();
            baseRequest.setHandled(true);
            return;
        }
        QueryHandlerRegistry queryHandlerRegistry = (QueryHandlerRegistry)this.bus.getExtension(QueryHandlerRegistry.class);
        if (null != req.getQueryString() && queryHandlerRegistry != null) {
            String reqAddr = req.getRequestURL().toString();
            String requestURL = reqAddr + "?" + req.getQueryString();
            String pathInfo = req.getPathInfo();
            for (QueryHandler qh : queryHandlerRegistry.getHandlers()) {
                boolean recognized = qh instanceof StemMatchingQueryHandler ? ((StemMatchingQueryHandler)qh).isRecognizedQuery(requestURL, pathInfo, this.endpointInfo, this.contextMatchOnExact()) : qh.isRecognizedQuery(requestURL, pathInfo, this.endpointInfo);
                if (!recognized) continue;
                EndpointInfo endpointInfo = this.endpointInfo;
                synchronized (endpointInfo) {
                    String oldAddress = this.updateEndpointAddress(reqAddr);
                    resp.setContentType(qh.getResponseContentType(requestURL, pathInfo));
                    try {
                        qh.writeResponse(requestURL, pathInfo, this.endpointInfo, (OutputStream)resp.getOutputStream());
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "writeResponse failed: ", ex);
                        try {
                            resp.sendError(500, ex.getMessage());
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                    }
                    this.endpointInfo.setAddress(oldAddress);
                    resp.getOutputStream().flush();
                    baseRequest.setHandled(true);
                    return;
                }
            }
        }
        try {
            BusFactory.setThreadDefaultBus((Bus)this.bus);
            this.serviceRequest(context, req, resp);
        }
        finally {
            BusFactory.setThreadDefaultBus(null);
        }
    }

    protected void serviceRequest(ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        MessageImpl inMessage;
        Request baseRequest;
        Request request = baseRequest = req instanceof Request ? (Request)req : HttpConnection.getCurrentConnection().getRequest();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Service http request on thread: " + Thread.currentThread());
        }
        if ((inMessage = this.retrieveFromContinuation(req)) == null) {
            inMessage = new MessageImpl();
            if (this.engine.getContinuationsEnabled()) {
                inMessage.put((Object)ContinuationProvider.class.getName(), (Object)new JettyContinuationProvider(req, (Message)inMessage));
            }
            this.setupMessage((Message)inMessage, context, req, resp);
            inMessage.setDestination((Destination)this);
            ExchangeImpl exchange = new ExchangeImpl();
            exchange.setInMessage((Message)inMessage);
            exchange.setSession((Session)new HTTPSession(req));
        }
        try {
            this.incomingObserver.onMessage((Message)inMessage);
            resp.flushBuffer();
            baseRequest.setHandled(true);
        }
        catch (SuspendedInvocationException ex) {
            throw ex.getRuntimeException();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        finally {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Finished servicing http request on thread: " + Thread.currentThread());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageImpl retrieveFromContinuation(HttpServletRequest req) {
        Continuation cont;
        MessageImpl m = null;
        if (!this.engine.getContinuationsEnabled()) {
            return null;
        }
        Continuation continuation = cont = ContinuationSupport.getContinuation((HttpServletRequest)req, null);
        synchronized (continuation) {
            Object o = cont.getObject();
            if (o instanceof ContinuationInfo) {
                ContinuationInfo ci = (ContinuationInfo)o;
                m = (MessageImpl)ci.getMessage();
                cont.setObject(ci.getUserObject());
            }
            if (m == null && !cont.isNew()) {
                String message = "No message for existing continuation, status : " + (cont.isPending() ? "Pending" : "Resumed");
                if (!(o instanceof ContinuationInfo)) {
                    message = message + ", ContinuationInfo object is unavailable";
                }
                LOG.warning(message);
            }
        }
        return m;
    }

    public void shutdown() {
        this.transportFactory.removeDestination(this.endpointInfo);
        super.shutdown();
    }

    public ServerEngine getEngine() {
        return this.engine;
    }

    private String getStem(String baseURI) {
        return baseURI.substring(0, baseURI.lastIndexOf("/"));
    }
}

