/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.IssuedToken;
import org.apache.cxf.ws.security.policy.model.KerberosToken;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.SecurityContextToken;
import org.apache.cxf.ws.security.policy.model.SupportingToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.policy.model.UsernameToken;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractSupportingTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignedEndorsingTokenPolicyValidator
extends AbstractSupportingTokenPolicyValidator {
    public SignedEndorsingTokenPolicyValidator() {
        this.setSigned(true);
        this.setEndorsed(true);
    }

    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.SIGNED_ENDORSING_SUPPORTING_TOKENS);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        this.setMessage(message);
        this.setResults(results);
        this.setSignedResults(signedResults);
        this.setEncryptedResults(encryptedResults);
        for (AssertionInfo ai : ais) {
            SupportingToken binding = (SupportingToken)ai.getAssertion();
            if (SPConstants.SupportTokenType.SUPPORTING_TOKEN_SIGNED_ENDORSING != binding.getTokenType()) continue;
            ai.setAsserted(true);
            this.setSignedParts(binding.getSignedParts());
            this.setEncryptedParts(binding.getEncryptedParts());
            this.setSignedElements(binding.getSignedElements());
            this.setEncryptedElements(binding.getEncryptedElements());
            List<Token> tokens = binding.getTokens();
            for (Token token : tokens) {
                if (!this.isTokenRequired(token, message)) continue;
                boolean derived = token.isDerivedKeys();
                this.setDerived(derived);
                boolean processingFailed = false;
                if (token instanceof KerberosToken) {
                    if (!this.processKerberosTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof SamlToken) {
                    if (!this.processSAMLTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof X509Token) {
                    if (!this.processX509Tokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof UsernameToken) {
                    if (!this.processUsernameTokens()) {
                        processingFailed = true;
                    }
                } else if (token instanceof SecurityContextToken) {
                    if (!this.processSCTokens()) {
                        processingFailed = true;
                    }
                } else if (!(token instanceof IssuedToken)) {
                    processingFailed = true;
                }
                if (!processingFailed) continue;
                ai.setNotAsserted("The received token does not match the signed endorsing supporting token requirement");
                return false;
            }
        }
        return true;
    }
}

