/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.tools.corba.common.idltypes.IdlDefn;
import org.apache.cxf.tools.corba.common.idltypes.IdlPrimitive;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlString;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;
import org.apache.cxf.tools.corba.common.idltypes.IdlWString;

public final class IdlRoot
extends IdlScopeBase {
    private Map<String, IdlType> primitiveTypes = new HashMap<String, IdlType>();
    private List<String> includeList = new ArrayList<String>();

    private IdlRoot() {
        super(null, "");
        for (short i = 1; i <= 15; i = (short)(i + 1)) {
            IdlPrimitive prim = IdlPrimitive.create(this, i);
            this.primitiveTypes.put(prim.wsdlName(), prim);
        }
        this.primitiveTypes.put("string", IdlString.create());
        this.primitiveTypes.put("wstring", IdlWString.create());
    }

    public static IdlRoot create() {
        return new IdlRoot();
    }

    @Override
    public IdlDefn lookup(String nm) {
        return this.lookup(nm, false);
    }

    @Override
    public IdlDefn lookup(String nm, boolean undefined) {
        IdlDefn result = null;
        result = !undefined && this.primitiveTypes.containsKey(nm) ? (IdlDefn)this.primitiveTypes.get(nm) : super.lookup(nm, undefined);
        return result;
    }

    public void addInclude(String includefile) {
        if (!this.includeList.contains(includefile)) {
            this.includeList.add(includefile);
        }
    }

    @Override
    public void write(PrintWriter pw) {
        for (String s : this.includeList) {
            pw.println("#include " + s);
        }
        if (!this.includeList.isEmpty()) {
            pw.println();
        }
        super.writeFwd(pw);
        super.write(pw);
    }
}

