/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.maven_plugin;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.maven_plugin.XJCErrorListener;
import org.apache.cxf.maven_plugin.XSDToJavaRunner;
import org.apache.cxf.maven_plugin.XsdOption;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractXSDToJavaMojo
extends AbstractMojo {
    @Component
    protected MavenProject project;
    @Parameter
    XsdOption[] xsdOptions;
    @Parameter(defaultValue="${project.build.directory}/cxf-xsd-plugin-markers", property="cxf.markerDirectory")
    File markerDirectory;
    @Parameter
    private List<String> extensions;
    @Component
    private BuildContext buildContext;
    @Component
    private RepositorySystem repository;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remotePluginRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;
    @Parameter(defaultValue="false")
    private boolean fork;
    @Parameter(defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(defaultValue="${java.home}/bin/java")
    private String javaExecutable;
    @Parameter(property="cxf.xjc.jvmArgs")
    private String additionalJvmArgs;
    @Parameter(property="plugin.artifacts", readonly=true, required=true)
    private List<Artifact> pluginArtifacts;

    abstract String getOutputDir();

    private URI mapLocation(String s) throws MojoExecutionException {
        try {
            URI uri;
            File file = new File(s).getAbsoluteFile();
            if (file.exists()) {
                uri = file.toURI();
            } else {
                file = new File(this.project.getBasedir(), s).getAbsoluteFile();
                if (file.exists()) {
                    uri = file.toURI();
                } else {
                    try {
                        uri = new URI(s);
                    }
                    catch (URISyntaxException use) {
                        file = new File(s).getAbsoluteFile();
                        if (file.getParentFile().exists()) {
                            return file.toURI();
                        }
                        throw use;
                    }
                }
            }
            if ("classpath".equals(uri.getScheme())) {
                URL url = Thread.currentThread().getContextClassLoader().getResource(s.substring(10));
                if (url == null) {
                    url = Thread.currentThread().getContextClassLoader().getResource(s.substring(11));
                }
                if (url != null) {
                    uri = url.toURI();
                }
            }
            return uri;
        }
        catch (URISyntaxException e1) {
            throw new MojoExecutionException("Could not map " + s, (Exception)e1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.isJava9Compatible()) {
            this.fork = true;
            this.additionalJvmArgs = "--add-exports=jdk.xml.dom/org.w3c.dom.html=ALL-UNNAMED --add-exports=java.xml/com.sun.org.apache.xerces.internal.impl.xs=ALL-UNNAMED --add-opens java.base/java.security=ALL-UNNAMED --add-opens java.base/java.net=ALL-UNNAMED --add-opens java.base/java.lang=ALL-UNNAMED --add-opens java.base/java.util=ALL-UNNAMED --add-opens java.base/java.util.concurrent=ALL-UNNAMED " + (this.additionalJvmArgs == null ? "" : this.additionalJvmArgs);
        }
        String outputDir = this.getOutputDir();
        File outputDirFile = new File(outputDir);
        outputDirFile.mkdirs();
        this.markerDirectory.mkdirs();
        boolean result = true;
        if (this.xsdOptions == null) {
            throw new MojoExecutionException("Must specify xsdOptions");
        }
        for (int x = 0; x < this.xsdOptions.length; ++x) {
            String[] xsdFiles;
            ClassLoader origLoader = Thread.currentThread().getContextClassLoader();
            for (String xsdFile : xsdFiles = this.getXsdFiles(this.xsdOptions[x].getXsdDir(), this.xsdOptions[x].getXsd())) {
                try {
                    File[] files;
                    URI xsdURI = this.mapLocation(xsdFile);
                    URI basedir = this.project.getBasedir().toURI();
                    String doneFileName = xsdURI.toString();
                    if (doneFileName.startsWith(basedir.toString())) {
                        doneFileName = doneFileName.substring(basedir.toString().length());
                    }
                    doneFileName = doneFileName.replace('?', '_').replace('&', '_').replace('/', '_').replace('\\', '_').replace(':', '_').replace('!', '_');
                    File doneFile = new File(this.markerDirectory, "." + doneFileName + ".DONE");
                    long srctimestamp = 0L;
                    if ("file".equals(xsdURI.getScheme())) {
                        srctimestamp = new File(xsdURI).lastModified();
                    } else {
                        try {
                            srctimestamp = xsdURI.toURL().openConnection().getDate();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (this.xsdOptions[x].getBindingFiles() != null) {
                        for (String bf : this.xsdOptions[x].getBindingFiles()) {
                            long bts;
                            URI bindingURI = this.mapLocation(bf);
                            if (!"file".equals(bindingURI.getScheme()) || (bts = new File(bindingURI).lastModified()) <= srctimestamp) continue;
                            srctimestamp = bts;
                        }
                    }
                    boolean doWork = false;
                    if (!doneFile.exists()) {
                        doWork = true;
                    } else if (srctimestamp > doneFile.lastModified()) {
                        doWork = true;
                    } else {
                        files = this.xsdOptions[x].getDependencies();
                        if (files != null) {
                            for (int z = 0; z < files.length; ++z) {
                                if (files[z].lastModified() <= doneFile.lastModified()) continue;
                                doWork = true;
                            }
                        }
                    }
                    if (doWork) {
                        try {
                            File[] dirs;
                            int i;
                            files = this.xsdOptions[x].getDependencies();
                            if (files != null) {
                                for (int z = 0; z < files.length; ++z) {
                                    if (files[z].lastModified() <= doneFile.lastModified()) continue;
                                    this.buildContext.removeMessages(files[z]);
                                }
                            }
                            this.removeMessages(xsdFile);
                            if (this.xsdOptions[x].getBindingFiles() != null) {
                                for (String bf : this.xsdOptions[x].getBindingFiles()) {
                                    this.removeMessages(bf);
                                }
                            }
                            if ((i = this.run(this.xsdOptions[x], xsdFile, outputDir)) == 0) {
                                doneFile.delete();
                                doneFile.createNewFile();
                            }
                            if ((dirs = this.xsdOptions[x].getDeleteDirs()) != null) {
                                for (int idx = 0; idx < dirs.length; ++idx) {
                                    result = result && this.deleteDir(dirs[idx]);
                                }
                            }
                            this.buildContext.refresh(outputDirFile);
                        }
                        catch (Exception e) {
                            throw new MojoExecutionException(e.getMessage(), e);
                        }
                    }
                    if (result) continue;
                    throw new MojoExecutionException("Could not delete redundant dirs");
                }
                finally {
                    Thread.currentThread().setContextClassLoader(origLoader);
                }
            }
        }
    }

    private String[] getXsdFiles(String xsdDir, String xsd) throws MojoExecutionException {
        String[] xsdFiles;
        if (xsdDir != null && !xsdDir.isEmpty()) {
            File dir = new File(xsdDir);
            if (!dir.isDirectory()) {
                throw new MojoExecutionException("Error, xsdDir \"" + xsdDir + "\" does not exist.");
            }
            String[] fileList = dir.list(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xsd");
                }
            });
            if (fileList == null || fileList.length == 0) {
                throw new MojoExecutionException("Error, xsdDir \"" + xsdDir + "\" does not contain any *.xsd files.");
            }
            xsdFiles = new String[fileList.length];
            for (int i = 0; i < fileList.length; ++i) {
                xsdFiles[i] = xsdDir + (xsdDir.endsWith(File.separator) ? "" : File.separator) + fileList[i];
            }
        } else {
            xsdFiles = new String[]{xsd};
        }
        return xsdFiles;
    }

    private Set<File> resolve(String artifactDescriptor) throws MojoExecutionException, RepositoryException {
        HashSet<File> files = new HashSet<File>();
        for (ArtifactResult artifactResult : this.repository.resolveDependencies(this.repoSession, new DependencyRequest(new CollectRequest(new Dependency((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(artifactDescriptor), null), this.remoteRepos), null)).getArtifactResults()) {
            org.eclipse.aether.artifact.Artifact artifact = artifactResult.getArtifact();
            if (null == artifact || null == artifact.getFile()) {
                throw new MojoExecutionException("Unable to resolve " + artifact.toString() + " while resolving " + artifactDescriptor);
            }
            files.add(artifact.getFile());
        }
        return files;
    }

    protected List<String> getClasspathElements() throws DependencyResolutionRequiredException {
        return this.project.getCompileClasspathElements();
    }

    protected boolean isJava9Compatible() {
        String version = System.getProperty("java.specification.version");
        int majorVersion = version.contains(".") ? Integer.parseInt(version.split("\\.")[1]) : Integer.parseInt(version);
        return majorVersion >= 9;
    }

    private int run(XsdOption option, String xsdFile, String outputDir) throws Exception {
        if (!this.fork) {
            String[] args = this.getArguments(option, outputDir);
            this.getLog().debug((CharSequence)("Args: " + Arrays.asList(args)));
            XJCErrorListener listener = new XJCErrorListener(this.buildContext);
            int i = new XSDToJavaRunner(args, listener, new File(xsdFile), this.getClasspathElements()).run();
            if (i != 0 && listener.getFirstError() != null) {
                throw listener.getFirstError();
            }
            return i;
        }
        return this.runForked(option, outputDir);
    }

    private void removeMessages(String file) throws MojoExecutionException {
        File f;
        if (file == null) {
            return;
        }
        URI location = this.mapLocation(file);
        if ("file".equals(location.getScheme()) && (f = new File(location)).exists()) {
            this.buildContext.removeMessages(f);
        }
    }

    private String[] getArguments(XsdOption option, String outputDir) throws MojoExecutionException, MalformedURLException {
        String[] xsdFiles;
        ArrayList<URL> newCp = new ArrayList<URL>();
        ArrayList<String> list = new ArrayList<String>();
        if (this.extensions != null && this.extensions.size() > 0) {
            try {
                for (String ext : this.extensions) {
                    for (File file : this.resolve(ext)) {
                        list.add("-classpath");
                        list.add(file.toURI().toURL().toExternalForm());
                        newCp.add(file.toURI().toURL());
                    }
                }
            }
            catch (Exception ex) {
                throw new MojoExecutionException("Could not download extension artifact", ex);
            }
        }
        if (!newCp.isEmpty()) {
            Thread.currentThread().setContextClassLoader(new URLClassLoader(newCp.toArray(new URL[0]), Thread.currentThread().getContextClassLoader()));
        }
        if (option.getPackagename() != null) {
            list.add("-p");
            list.add(option.getPackagename());
        }
        if (option.getBindingFiles() != null) {
            for (String bf : option.getBindingFiles()) {
                list.add("-b");
                list.add(this.mapLocation(bf).toString());
            }
        }
        if (option.getCatalog() != null) {
            list.add("-catalog");
            list.add(option.getCatalog());
        }
        if (option.isExtension()) {
            list.add("-extension");
        }
        if (option.getExtensionArgs() != null) {
            list.addAll(option.getExtensionArgs());
        }
        if (this.getLog().isDebugEnabled()) {
            list.add("-verbose");
        }
        list.add("-encoding");
        list.add(this.encoding);
        for (String xsdFile : xsdFiles = this.getXsdFiles(option.getXsdDir(), option.getXsd())) {
            list.add("-d");
            list.add(outputDir);
            list.add(this.mapLocation(xsdFile).toString());
        }
        return list.toArray(new String[0]);
    }

    private boolean deleteDir(File f) {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                this.deleteDir(files[idx]);
            }
        }
        if (f.exists()) {
            return f.delete();
        }
        return true;
    }

    private File getJavaExecutable() throws IOException {
        String exe = this.isWindows() && !this.javaExecutable.endsWith(".exe") ? ".exe" : "";
        File javaExe = new File(this.javaExecutable + exe);
        if (!javaExe.isFile()) {
            throw new IOException("The java executable '" + javaExe + "' doesn't exist or is not a file.Verify the <javaExecutable/> parameter.");
        }
        return javaExe;
    }

    private boolean isWindows() {
        String osName = System.getProperty("os.name");
        if (osName == null) {
            return false;
        }
        return osName.startsWith("Windows");
    }

    private int runForked(XsdOption option, String outputDir) throws Exception {
        int exitCode;
        String[] args = this.getArguments(option, outputDir);
        Commandline cmd = new Commandline();
        cmd.getShell().setQuotedArgumentsEnabled(true);
        cmd.setWorkingDirectory(this.project.getBuild().getDirectory());
        try {
            cmd.setExecutable(this.getJavaExecutable().getAbsolutePath());
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        cmd.createArg().setLine(this.additionalJvmArgs);
        File file = null;
        try {
            file = File.createTempFile("cxf-xjc-plugin", ".jar");
            file.deleteOnExit();
            JarArchiver jar = new JarArchiver();
            jar.setDestFile(file.getAbsoluteFile());
            Manifest manifest = new Manifest();
            Manifest.Attribute attr = new Manifest.Attribute();
            attr.setName("Class-Path");
            StringBuilder b = new StringBuilder(8000);
            for (String cp : this.getClasspathElements()) {
                URI uri = this.mapLocation(cp);
                if (uri == null) continue;
                b.append(uri.toString()).append(' ');
            }
            for (Artifact a : this.pluginArtifacts) {
                b.append(a.getFile().toURI().toURL().toExternalForm()).append(' ');
            }
            attr.setValue(b.toString());
            manifest.getMainSection().addConfiguredAttribute(attr);
            attr = new Manifest.Attribute();
            attr.setName("Main-Class");
            attr.setValue(XSDToJavaRunner.class.getName());
            manifest.getMainSection().addConfiguredAttribute(attr);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Manifest: " + manifest));
            }
            jar.addConfiguredManifest(manifest);
            jar.createArchive();
            cmd.createArg().setValue("-jar");
            String tmpFilePath = file.getAbsolutePath();
            if (tmpFilePath.contains(" ")) {
                tmpFilePath = "\"" + tmpFilePath + "\"";
            }
            cmd.createArg().setValue(tmpFilePath);
        }
        catch (Exception e1) {
            throw new MojoExecutionException("Could not create runtime jar", e1);
        }
        cmd.addArguments(args);
        StreamConsumer out = new StreamConsumer(){
            File file;
            int severity;
            int linenum;
            int column;
            StringBuilder message = new StringBuilder();

            public void consumeLine(String line) {
                if (AbstractXSDToJavaMojo.this.getLog().isDebugEnabled()) {
                    AbstractXSDToJavaMojo.this.getLog().debug((CharSequence)line);
                }
                if (line.startsWith("DONE")) {
                    AbstractXSDToJavaMojo.this.buildContext.addMessage(this.file, this.linenum, this.column, this.message.toString(), this.severity, null);
                } else if (line.startsWith("MSG: ") || line.startsWith("ERROR: ") || line.startsWith("WARNING: ")) {
                    this.file = new File(line.substring(line.indexOf(32)).trim());
                    String type = line.substring(0, line.indexOf(58));
                    this.severity = type.contains("ERROR") ? 2 : (type.contains("WARNING") ? 1 : 0);
                    this.linenum = 0;
                    this.column = 0;
                    this.message.setLength(0);
                } else if (line.startsWith("Col: ")) {
                    this.column = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else if (line.startsWith("Line: ")) {
                    this.linenum = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else if (line.startsWith("Severity: ")) {
                    this.severity = Integer.parseInt(line.substring(line.indexOf(32)).trim());
                } else {
                    this.message.append(line).append('\n');
                }
            }
        };
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cmd, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (CommandLineException e) {
            this.getLog().debug((Throwable)e);
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        String cmdLine = CommandLineUtils.toString((String[])cmd.getCommandline());
        if (exitCode != 0) {
            StringBuffer msg = new StringBuffer("\nExit code: ");
            msg.append(exitCode);
            msg.append('\n');
            msg.append("Command line was: ").append(cmdLine).append('\n').append('\n');
            throw new MojoExecutionException(msg.toString());
        }
        file.delete();
        return 0;
    }
}

