/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import org.apache.datasketches.Util;
import org.apache.datasketches.req.ReqDebug;
import org.apache.datasketches.req.ReqSketch;

public class ReqSketchBuilder {
    private static final int DEFAULT_K = 12;
    private int bK = 12;
    private boolean bHRA = true;
    private boolean bLtEq = false;
    private ReqDebug bReqDebug = null;

    public ReqSketch build() {
        ReqSketch sk = new ReqSketch(this.bK, this.bHRA, this.bReqDebug);
        sk.setLessThanOrEqual(this.bLtEq);
        return sk;
    }

    public boolean getHighRankAccuracy() {
        return this.bHRA;
    }

    public int getK() {
        return this.bK;
    }

    public boolean getLessThanOrEqual() {
        return this.bLtEq;
    }

    public ReqDebug getReqDebug() {
        return this.bReqDebug;
    }

    public ReqSketchBuilder setHighRankAccuracy(boolean hra) {
        this.bHRA = hra;
        return this;
    }

    public ReqSketchBuilder setK(int k) {
        this.bK = k;
        return this;
    }

    public ReqSketchBuilder setLessThanOrEqual(boolean ltEq) {
        this.bLtEq = ltEq;
        return this;
    }

    public ReqSketchBuilder setReqDebug(ReqDebug reqDebug) {
        this.bReqDebug = reqDebug;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ReqSketchBuilder configuration:").append(Util.LS);
        sb.append("K:").append('\t').append(this.bK).append(Util.LS);
        sb.append("HRA:").append('\t').append(this.bHRA).append(Util.LS);
        sb.append("LtEq").append('\t').append(this.bLtEq).append(Util.LS);
        String valid = this.bReqDebug != null ? "valid" : "invalid";
        sb.append("ReqDebug:").append('\t').append(valid).append(Util.LS);
        return sb.toString();
    }
}

