/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.memory.internal;

import java.nio.ByteOrder;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.internal.AllocateDirect;
import org.apache.datasketches.memory.internal.BaseWritableBufferImpl;
import org.apache.datasketches.memory.internal.BaseWritableMemoryImpl;
import org.apache.datasketches.memory.internal.DirectNonNativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.DirectNonNativeWritableMemoryImpl;
import org.apache.datasketches.memory.internal.DirectWritableMemoryImpl;
import org.apache.datasketches.memory.internal.NativeWritableBufferImpl;
import org.apache.datasketches.memory.internal.Util;

final class DirectWritableBufferImpl
extends NativeWritableBufferImpl {
    private final AllocateDirect direct;

    DirectWritableBufferImpl(AllocateDirect direct, long offsetBytes, long capacityBytes, int typeId, long cumOffsetBytes, MemoryRequestServer memReqSvr) {
        super(capacityBytes);
        this.direct = direct;
        this.offsetBytes = offsetBytes;
        this.capacityBytes = capacityBytes;
        this.typeId = DirectWritableBufferImpl.removeNnBuf(typeId) | 8 | 0x40 | 0;
        this.cumOffsetBytes = cumOffsetBytes;
        this.memReqSvr = memReqSvr;
        if (this.owner != null && this.owner != Thread.currentThread()) {
            throw new IllegalStateException("Attempted access outside owning thread");
        }
        this.owner = Thread.currentThread();
    }

    @Override
    BaseWritableBufferImpl toWritableRegion(long regionOffsetBytes, long capacityBytes, boolean readOnly, ByteOrder byteOrder) {
        long newOffsetBytes = this.offsetBytes + regionOffsetBytes;
        long newCumOffsetBytes = this.cumOffsetBytes + regionOffsetBytes;
        int typeIdOut = DirectWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 2 | (readOnly ? 1 : 0);
        if (Util.isNativeByteOrder(byteOrder)) {
            return new DirectWritableBufferImpl(this.direct, newOffsetBytes, capacityBytes, typeIdOut |= 0, newCumOffsetBytes, this.memReqSvr);
        }
        return new DirectNonNativeWritableBufferImpl(this.direct, newOffsetBytes, capacityBytes, typeIdOut |= 0x20, newCumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableMemoryImpl toWritableMemory(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = DirectWritableBufferImpl.removeNnBuf(this.typeId) | 0 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new DirectWritableMemoryImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new DirectNonNativeWritableMemoryImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    BaseWritableBufferImpl toDuplicate(boolean readOnly, ByteOrder byteOrder) {
        int typeIdOut = DirectWritableBufferImpl.removeNnBuf(this.typeId) | 0x40 | 4 | (readOnly ? 1 : 0);
        if (byteOrder == ByteOrder.nativeOrder()) {
            return new DirectWritableBufferImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0, this.cumOffsetBytes, this.memReqSvr);
        }
        return new DirectNonNativeWritableBufferImpl(this.direct, this.offsetBytes, this.capacityBytes, typeIdOut |= 0x20, this.cumOffsetBytes, this.memReqSvr);
    }

    @Override
    public void close() {
        this.checkValid();
        DirectWritableBufferImpl.checkThread(this.owner);
        this.direct.close();
    }

    @Override
    Object getUnsafeObject() {
        return null;
    }

    @Override
    public boolean isAlive() {
        return this.direct.getValid().get();
    }
}

