/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import java.util.Arrays;
import org.apache.directory.api.ldap.model.message.AbstractResultResponse;
import org.apache.directory.api.ldap.model.message.IntermediateResponse;
import org.apache.directory.api.util.Strings;

public class IntermediateResponseImpl
extends AbstractResultResponse
implements IntermediateResponse {
    static final long serialVersionUID = -6646752766410531060L;
    protected String responseName;
    protected byte[] responseValue;

    public IntermediateResponseImpl(int id) {
        super(id, TYPE);
    }

    public byte[] getResponseValue() {
        if (this.responseValue == null) {
            return null;
        }
        byte[] copy = new byte[this.responseValue.length];
        System.arraycopy(this.responseValue, 0, copy, 0, this.responseValue.length);
        return copy;
    }

    public void setResponseValue(byte[] value) {
        if (value != null) {
            this.responseValue = new byte[value.length];
            System.arraycopy(value, 0, this.responseValue, 0, value.length);
        } else {
            this.responseValue = null;
        }
    }

    public String getResponseName() {
        return this.responseName == null ? "" : this.responseName;
    }

    public void setResponseName(String oid) {
        this.responseName = oid;
    }

    public int hashCode() {
        int hash = 37;
        if (this.responseName != null) {
            hash = hash * 17 + this.responseName.hashCode();
        }
        if (this.responseValue != null) {
            hash = hash * 17 + Arrays.hashCode(this.responseValue);
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof IntermediateResponse)) {
            return false;
        }
        IntermediateResponse resp = (IntermediateResponse)obj;
        if (this.responseName != null && resp.getResponseName() == null) {
            return false;
        }
        if (this.responseName == null && resp.getResponseName() != null) {
            return false;
        }
        if (this.responseName != null && resp.getResponseName() != null && !this.responseName.equals(resp.getResponseName())) {
            return false;
        }
        if (this.responseValue != null && resp.getResponseValue() == null) {
            return false;
        }
        if (this.responseValue == null && resp.getResponseValue() != null) {
            return false;
        }
        return this.responseValue == null || resp.getResponseValue() == null || Arrays.equals(this.responseValue, resp.getResponseValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Intermediate Response\n");
        if (this.responseName != null) {
            sb.append("        Response name :'").append(this.responseName).append("'\n");
        }
        if (this.responseValue != null) {
            sb.append("        ResponseValue :'");
            sb.append(Strings.dumpBytes((byte[])this.responseValue));
            sb.append("'\n");
        }
        sb.append(super.toString());
        return super.toString(sb.toString());
    }
}

