/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.DitContentRule;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.api.ldap.model.schema.registries.AttributeTypeRegistry;
import org.apache.directory.api.ldap.model.schema.registries.ObjectClassRegistry;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DitContentRuleHelper {
    private static final Logger LOG = LoggerFactory.getLogger(DitContentRuleHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(DitContentRule ditContentRule, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            try {
                ditContentRule.unlock();
                AttributeTypeRegistry atRegistry = registries.getAttributeTypeRegistry();
                ObjectClassRegistry ocRegistry = registries.getObjectClassRegistry();
                if (ditContentRule.getMayAttributeTypeOids() != null) {
                    ditContentRule.getMayAttributeTypes().clear();
                    for (String oid : ditContentRule.getMayAttributeTypeOids()) {
                        ditContentRule.getMayAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getMustAttributeTypeOids() != null) {
                    ditContentRule.getMustAttributeTypes().clear();
                    for (String oid : ditContentRule.getMustAttributeTypeOids()) {
                        ditContentRule.getMustAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getNotAttributeTypeOids() != null) {
                    ditContentRule.getNotAttributeTypes().clear();
                    for (String oid : ditContentRule.getNotAttributeTypeOids()) {
                        ditContentRule.getNotAttributeTypes().add((AttributeType)atRegistry.lookup(oid));
                    }
                }
                if (ditContentRule.getAuxObjectClassOids() != null) {
                    ditContentRule.getAuxObjectClasses().clear();
                    for (String oid : ditContentRule.getAuxObjectClassOids()) {
                        ditContentRule.getAuxObjectClasses().add((ObjectClass)ocRegistry.lookup(oid));
                    }
                }
            }
            finally {
                ditContentRule.lock();
            }
        }
    }
}

