/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.registries.helper;

import java.util.List;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaException;
import org.apache.directory.api.ldap.model.exception.LdapSchemaExceptionCodes;
import org.apache.directory.api.ldap.model.schema.LdapSyntax;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.MutableMatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.comparators.ComparableComparator;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.api.ldap.model.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleHelper {
    private static final Logger LOG = LoggerFactory.getLogger(MatchingRuleHelper.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addToRegistries(MutableMatchingRule matchingRule, List<Throwable> errors, Registries registries) throws LdapException {
        block13: {
            if (registries != null) {
                try {
                    matchingRule.unlock();
                    if (registries == null) break block13;
                    ComparableComparator ldapComparator = null;
                    Normalizer normalizer = null;
                    LdapSyntax ldapSyntax = null;
                    try {
                        ldapComparator = (ComparableComparator)registries.getComparatorRegistry().lookup(matchingRule.getOid());
                    }
                    catch (LdapException ne) {
                        ldapComparator = new ComparableComparator(matchingRule.getOid());
                    }
                    try {
                        normalizer = (Normalizer)registries.getNormalizerRegistry().lookup(matchingRule.getOid());
                    }
                    catch (LdapException ne) {
                        normalizer = new NoOpNormalizer(matchingRule.getOid());
                    }
                    try {
                        ldapSyntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(matchingRule.getSyntaxOid());
                    }
                    catch (LdapException ne) {
                        String msg = I18n.err((I18n)I18n.ERR_04317, (Object[])new Object[0]);
                        LdapSchemaException ldapSchemaException = new LdapSchemaException(LdapSchemaExceptionCodes.MR_NONEXISTENT_SYNTAX, msg, ne);
                        ldapSchemaException.setSourceObject(matchingRule);
                        ldapSchemaException.setRelatedId(matchingRule.getSyntaxOid());
                        errors.add(ldapSchemaException);
                        LOG.info(msg);
                    }
                    if (ldapComparator != null) {
                        registries.addReference(matchingRule, ldapComparator);
                        matchingRule.setLdapComparator(ldapComparator);
                    }
                    if (normalizer != null) {
                        registries.addReference(matchingRule, normalizer);
                        matchingRule.setNormalizer(normalizer);
                    }
                    if (ldapSyntax != null) {
                        registries.addReference(matchingRule, ldapSyntax);
                        matchingRule.setSyntax(ldapSyntax);
                    }
                }
                finally {
                    matchingRule.lock();
                }
            }
        }
    }

    public static void removeFromRegistries(MatchingRule matchingRule, List<Throwable> errors, Registries registries) throws LdapException {
        if (registries != null) {
            if (matchingRule.getLdapComparator() != null) {
                registries.delReference(matchingRule, matchingRule.getLdapComparator());
            }
            if (matchingRule.getSyntax() != null) {
                registries.delReference(matchingRule, matchingRule.getSyntax());
            }
            if (matchingRule.getNormalizer() != null) {
                registries.delReference(matchingRule, matchingRule.getNormalizer());
            }
        }
    }
}

