/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.schema.AbstractSchemaObject;
import org.apache.directory.api.ldap.model.schema.SchemaObjectType;
import org.apache.directory.api.util.Strings;

public abstract class LoadableSchemaObject
extends AbstractSchemaObject {
    private static final long serialVersionUID = 2L;
    private String fqcn = "";
    private String bytecode = null;

    protected LoadableSchemaObject(SchemaObjectType objectType, String oid) {
        super(objectType, oid);
    }

    protected LoadableSchemaObject(SchemaObjectType objectType) {
        super(objectType);
    }

    public String getBytecode() {
        return this.bytecode;
    }

    public void setBytecode(String bytecode) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.bytecode = bytecode;
        }
    }

    public String getFqcn() {
        return this.fqcn;
    }

    public void setFqcn(String fqcn) {
        if (this.locked) {
            throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_13700_CANNOT_MODIFY_LOCKED_SCHEMA_OBJECT, (Object[])new Object[]{this.getName()}));
        }
        if (!this.isReadOnly) {
            this.fqcn = fqcn;
        }
    }

    @Override
    public LoadableSchemaObject copy() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof LoadableSchemaObject)) {
            return false;
        }
        LoadableSchemaObject that = (LoadableSchemaObject)o;
        if (this.fqcn == null) {
            return that.fqcn == null;
        }
        return this.fqcn.equals(that.fqcn);
    }

    public boolean isValid() {
        String className = this.getClass().getName();
        if (Strings.isEmpty((String)this.fqcn)) {
            this.fqcn = className;
            return true;
        }
        return className.equals(this.fqcn);
    }
}

