/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.schemaextractor.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifReader;
import org.apache.directory.api.ldap.schemaextractor.SchemaLdifExtractor;
import org.apache.directory.api.ldap.schemaextractor.UniqueResourceException;
import org.apache.directory.api.ldap.schemaextractor.impl.ResourceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSchemaLdifExtractor
implements SchemaLdifExtractor {
    private static final String BASE_PATH = "";
    private static final String SCHEMA_SUBDIR = "schema";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaLdifExtractor.class);
    private static final Pattern EXTRACT_PATTERN = Pattern.compile(".*schema[/\\Q\\\\E]ou=schema.*\\.ldif");
    private boolean extracted;
    private File outputDirectory;

    public DefaultSchemaLdifExtractor(File outputDirectory) {
        LOG.debug("BASE_PATH set to {}, outputDirectory set to {}", (Object)BASE_PATH, (Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        File schemaDirectory = new File(outputDirectory, SCHEMA_SUBDIR);
        if (!outputDirectory.exists()) {
            LOG.debug("Creating output directory: {}", (Object)outputDirectory);
            if (!outputDirectory.mkdir()) {
                LOG.error("Failed to create outputDirectory: {}", (Object)outputDirectory);
            }
        } else {
            LOG.debug("Output directory exists: no need to create.");
        }
        if (!schemaDirectory.exists()) {
            LOG.info("Schema directory '{}' does NOT exist: extracted state set to false.", (Object)schemaDirectory);
            this.extracted = false;
        } else {
            LOG.info("Schema directory '{}' does exist: extracted state set to true.", (Object)schemaDirectory);
            this.extracted = true;
        }
    }

    @Override
    public boolean isExtracted() {
        return this.extracted;
    }

    @Override
    public void extractOrCopy(boolean overwrite) throws IOException {
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_09001_DIRECTORY_CREATION_FAILED, (Object[])new Object[]{this.outputDirectory.getAbsolutePath()}));
        }
        File schemaDirectory = new File(this.outputDirectory, SCHEMA_SUBDIR);
        if (!schemaDirectory.exists()) {
            if (!schemaDirectory.mkdirs()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_09001_DIRECTORY_CREATION_FAILED, (Object[])new Object[]{schemaDirectory.getAbsolutePath()}));
            }
        } else if (!overwrite) {
            throw new IOException(I18n.err((I18n)I18n.ERR_08001, (Object[])new Object[]{schemaDirectory.getAbsolutePath()}));
        }
        Map<String, Boolean> list = ResourceMap.getResources(EXTRACT_PATTERN);
        for (Map.Entry<String, Boolean> entry : list.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.extractFromClassLoader(entry.getKey());
                continue;
            }
            File resource = new File(entry.getKey());
            this.copyFile(resource, this.getDestinationFile(resource));
        }
    }

    @Override
    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private void copyFile(File source, File destination) throws IOException {
        LOG.debug("copyFile(): source = {}, destination = {}", (Object)source, (Object)destination);
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            throw new IOException(I18n.err((I18n)I18n.ERR_09001_DIRECTORY_CREATION_FAILED, (Object[])new Object[]{destination.getParentFile().getAbsolutePath()}));
        }
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err((I18n)I18n.ERR_08002, (Object[])new Object[]{source.getAbsolutePath()}));
        }
        FileWriter out = new FileWriter(destination);
        try {
            LdifReader ldifReader = new LdifReader(source);
            boolean first = true;
            LdifEntry ldifEntry = null;
            while (ldifReader.hasNext()) {
                if (first) {
                    ldifEntry = ldifReader.next();
                    if (ldifEntry.get("entryUUID") == null) {
                        UUID entryUuid = UUID.randomUUID();
                        ldifEntry.addAttribute("entryUUID", new Object[]{entryUuid.toString()});
                    }
                    first = false;
                    continue;
                }
                String msg = I18n.err((I18n)I18n.ERR_08003, (Object[])new Object[]{source});
                LOG.error(msg);
                throw new InvalidObjectException(msg);
            }
            ldifReader.close();
            String ldifString = "version: 1\n" + ldifEntry.toString();
            out.write(ldifString);
            out.flush();
        }
        catch (LdapLdifException ne) {
            String msg = I18n.err((I18n)I18n.ERR_08004, (Object[])new Object[]{source, ne.getLocalizedMessage()});
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
        catch (LdapException ne) {
            String msg = I18n.err((I18n)I18n.ERR_08004, (Object[])new Object[]{source, ne.getLocalizedMessage()});
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
        finally {
            out.close();
        }
    }

    private File assembleDestinationFile(Stack<String> fileComponentStack) {
        File destinationFile = this.outputDirectory.getAbsoluteFile();
        while (!fileComponentStack.isEmpty()) {
            destinationFile = new File(destinationFile, fileComponentStack.pop());
        }
        return destinationFile;
    }

    private File getDestinationFile(File resource) {
        Stack<String> fileComponentStack = new Stack<String>();
        fileComponentStack.push(resource.getName());
        for (File parent = resource.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.getName().equals(SCHEMA_SUBDIR)) {
                fileComponentStack.push(SCHEMA_SUBDIR);
                return this.assembleDestinationFile(fileComponentStack);
            }
            fileComponentStack.push(parent.getName());
            if (!parent.equals(parent.getParentFile()) && parent.getParentFile() != null) continue;
            throw new IllegalStateException(I18n.err((I18n)I18n.ERR_08005, (Object[])new Object[0]));
        }
        throw new IllegalStateException(I18n.err((I18n)I18n.ERR_08006, (Object[])new Object[0]));
    }

    public static InputStream getUniqueResourceAsStream(String resourceName, String resourceDescription) throws IOException {
        resourceName = BASE_PATH + resourceName;
        URL result = DefaultSchemaLdifExtractor.getUniqueResource(resourceName, resourceDescription);
        return result.openStream();
    }

    public static URL getUniqueResource(String resourceName, String resourceDescription) throws IOException {
        Enumeration<URL> resources = DefaultSchemaLdifExtractor.class.getClassLoader().getResources(resourceName);
        if (!resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, resourceDescription);
        }
        URL result = resources.nextElement();
        if (resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, result, resources, resourceDescription);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromClassLoader(String resource) throws IOException {
        byte[] buf = new byte[512];
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream(resource, "LDIF file in schema repository");
        try {
            File destination = new File(this.outputDirectory, resource);
            if (destination.exists()) {
                return;
            }
            if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
                throw new IOException(I18n.err((I18n)I18n.ERR_09001_DIRECTORY_CREATION_FAILED, (Object[])new Object[]{destination.getParentFile().getAbsolutePath()}));
            }
            FileOutputStream out = new FileOutputStream(destination);
            try {
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

