/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.decoder;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Enumeration;
import org.apache.directory.server.kerberos.shared.io.decoder.KerberosTimeDecoder;
import org.apache.directory.server.kerberos.shared.io.decoder.PrincipalNameDecoder;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessage;
import org.apache.directory.server.kerberos.shared.messages.ErrorMessageModifier;
import org.apache.directory.server.kerberos.shared.messages.value.KerberosPrincipalModifier;
import org.apache.directory.shared.asn1.der.ASN1InputStream;
import org.apache.directory.shared.asn1.der.DERApplicationSpecific;
import org.apache.directory.shared.asn1.der.DEREncodable;
import org.apache.directory.shared.asn1.der.DERGeneralString;
import org.apache.directory.shared.asn1.der.DERGeneralizedTime;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class ErrorMessageDecoder {
    public ErrorMessage decode(ByteBuffer in) throws IOException {
        ASN1InputStream ais = new ASN1InputStream(in);
        DERApplicationSpecific app = (DERApplicationSpecific)ais.readObject();
        DERSequence errorMessage = (DERSequence)app.getObject();
        return this.decodeErrorMessageSequence(errorMessage);
    }

    private ErrorMessage decodeErrorMessageSequence(DERSequence sequence) {
        ErrorMessageModifier errorModifier = new ErrorMessageModifier();
        KerberosPrincipalModifier clientModifier = new KerberosPrincipalModifier();
        KerberosPrincipalModifier serverModifier = new KerberosPrincipalModifier();
        Enumeration<DEREncodable> e = sequence.getObjects();
        while (e.hasMoreElements()) {
            DERTaggedObject object = (DERTaggedObject)e.nextElement();
            int tag = object.getTagNo();
            DEREncodable derObject = object.getObject();
            switch (tag) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    DERGeneralizedTime tag2 = (DERGeneralizedTime)derObject;
                    errorModifier.setClientTime(KerberosTimeDecoder.decode(tag2));
                    break;
                }
                case 3: {
                    DERInteger tag3 = (DERInteger)derObject;
                    errorModifier.setClientMicroSecond(tag3.intValue());
                    break;
                }
                case 4: {
                    DERGeneralizedTime tag4 = (DERGeneralizedTime)derObject;
                    errorModifier.setServerTime(KerberosTimeDecoder.decode(tag4));
                    break;
                }
                case 5: {
                    DERInteger tag5 = (DERInteger)derObject;
                    errorModifier.setServerMicroSecond(tag5.intValue());
                    break;
                }
                case 6: {
                    DERInteger tag6 = (DERInteger)derObject;
                    errorModifier.setErrorCode(tag6.intValue());
                    break;
                }
                case 7: {
                    DERGeneralString tag7 = (DERGeneralString)derObject;
                    clientModifier.setRealm(tag7.getString());
                    break;
                }
                case 8: {
                    DERSequence tag8 = (DERSequence)derObject;
                    clientModifier.setPrincipalName(PrincipalNameDecoder.decode(tag8));
                    break;
                }
                case 9: {
                    DERGeneralString tag9 = (DERGeneralString)derObject;
                    serverModifier.setRealm(tag9.getString());
                    break;
                }
                case 10: {
                    DERSequence tag10 = (DERSequence)derObject;
                    serverModifier.setPrincipalName(PrincipalNameDecoder.decode(tag10));
                    break;
                }
                case 11: {
                    DERGeneralString tag11 = (DERGeneralString)derObject;
                    errorModifier.setExplanatoryText(tag11.getString());
                    break;
                }
                case 12: {
                    DEROctetString tag12 = (DEROctetString)derObject;
                    errorModifier.setExplanatoryData(tag12.getOctets());
                }
            }
        }
        errorModifier.setClientPrincipal(clientModifier.getKerberosPrincipal());
        errorModifier.setServerPrincipal(serverModifier.getKerberosPrincipal());
        return errorModifier.getErrorMessage();
    }
}

