/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.shared.messages.Encodable;
import org.apache.directory.server.kerberos.shared.messages.value.AuthorizationDataEntry;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorizationData
extends AbstractAsn1Object
implements Encodable {
    private static final Logger log = LoggerFactory.getLogger(AuthorizationData.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private List<AuthorizationDataEntry> entries = new ArrayList<AuthorizationDataEntry>();
    private transient int authorizationDataLength;

    public void add(AuthorizationData data) {
        this.entries.addAll(data.entries);
    }

    public void add(AuthorizationDataEntry entry) {
        this.entries.add(entry);
    }

    public List<AuthorizationDataEntry> getEntries() {
        return this.entries;
    }

    @Override
    public int computeLength() {
        if (this.entries == null || this.entries.size() == 0) {
            this.authorizationDataLength = 1;
            return this.authorizationDataLength + 1;
        }
        this.authorizationDataLength = 0;
        for (AuthorizationDataEntry entry : this.entries) {
            this.authorizationDataLength += entry.computeLength();
        }
        return 1 + TLV.getNbBytes(this.authorizationDataLength) + this.authorizationDataLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.authorizationDataLength));
            if (this.entries != null && this.entries.size() != 0) {
                for (AuthorizationDataEntry entry : this.entries) {
                    entry.encode(buffer);
                }
            }
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_139, 1 + TLV.getNbBytes(this.authorizationDataLength) + this.authorizationDataLength, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("AuthorizationData encoding : {}", (Object)StringTools.dumpBytes(buffer.array()));
            log.debug("AuthorizationData initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        if (this.entries == null || this.entries.size() == 0) {
            sb.append(tabs).append("AuthorizationData : {}\n");
        } else {
            sb.append(tabs).append("AuthorizationData : {\n");
            boolean isFirst = true;
            for (AuthorizationDataEntry entry : this.entries) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('\n');
                }
                sb.append(entry.toString(tabs + "    ")).append('\n');
            }
            sb.append(tabs + "}");
        }
        return sb.toString();
    }
}

