/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.AndCursor;
import org.apache.directory.server.xdbm.search.impl.ApproximateCursor;
import org.apache.directory.server.xdbm.search.impl.ApproximateEvaluator;
import org.apache.directory.server.xdbm.search.impl.EqualityCursor;
import org.apache.directory.server.xdbm.search.impl.EqualityEvaluator;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.apache.directory.server.xdbm.search.impl.GreaterEqCursor;
import org.apache.directory.server.xdbm.search.impl.GreaterEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.LessEqCursor;
import org.apache.directory.server.xdbm.search.impl.LessEqEvaluator;
import org.apache.directory.server.xdbm.search.impl.NotCursor;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeCursor;
import org.apache.directory.server.xdbm.search.impl.OneLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.OrCursor;
import org.apache.directory.server.xdbm.search.impl.PresenceCursor;
import org.apache.directory.server.xdbm.search.impl.PresenceEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubstringCursor;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeCursor;
import org.apache.directory.server.xdbm.search.impl.SubtreeScopeEvaluator;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.ServerEntry;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.ScopeNode;
import org.apache.directory.shared.ldap.filter.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CursorBuilder<ID> {
    private Store<ServerEntry, ID> db = null;
    private EvaluatorBuilder<ID> evaluatorBuilder;

    public CursorBuilder(Store<ServerEntry, ID> db, EvaluatorBuilder<ID> evaluatorBuilder) {
        this.db = db;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    public <T> IndexCursor<?, ServerEntry, ID> build(ExprNode node) throws Exception {
        switch (node.getAssertionType()) {
            case APPROXIMATE: {
                return new ApproximateCursor(this.db, (ApproximateEvaluator)this.evaluatorBuilder.build(node));
            }
            case EQUALITY: {
                return new EqualityCursor(this.db, (EqualityEvaluator)this.evaluatorBuilder.build(node));
            }
            case GREATEREQ: {
                return new GreaterEqCursor(this.db, (GreaterEqEvaluator)this.evaluatorBuilder.build(node));
            }
            case LESSEQ: {
                return new LessEqCursor(this.db, (LessEqEvaluator)this.evaluatorBuilder.build(node));
            }
            case PRESENCE: {
                return new PresenceCursor<ID>(this.db, (PresenceEvaluator)this.evaluatorBuilder.build(node));
            }
            case SCOPE: {
                if (((ScopeNode)node).getScope() == SearchScope.ONELEVEL) {
                    return new OneLevelScopeCursor<ID>(this.db, (OneLevelScopeEvaluator)this.evaluatorBuilder.build(node));
                }
                return new SubtreeScopeCursor<ID>(this.db, (SubtreeScopeEvaluator)this.evaluatorBuilder.build(node));
            }
            case SUBSTRING: {
                return new SubstringCursor<ID>(this.db, (SubstringEvaluator)this.evaluatorBuilder.build(node));
            }
            case AND: {
                return this.buildAndCursor((AndNode)node);
            }
            case NOT: {
                return new NotCursor(this.db, this.evaluatorBuilder.build(((NotNode)node).getFirstChild()));
            }
            case OR: {
                return this.buildOrCursor((OrNode)node);
            }
            case ASSERTION: 
            case EXTENSIBLE: {
                throw new NotImplementedException();
            }
        }
        throw new IllegalStateException(I18n.err(I18n.ERR_260, new Object[]{node.getAssertionType()}));
    }

    private IndexCursor<?, ServerEntry, ID> buildOrCursor(OrNode node) throws Exception {
        List<ExprNode> children = node.getChildren();
        ArrayList childCursors = new ArrayList(children.size());
        ArrayList childEvaluators = new ArrayList(children.size());
        for (ExprNode child : children) {
            childCursors.add(this.build(child));
            childEvaluators.add(this.evaluatorBuilder.build(child));
        }
        return new OrCursor(childCursors, childEvaluators);
    }

    private IndexCursor<?, ServerEntry, ID> buildAndCursor(AndNode node) throws Exception {
        int minIndex = 0;
        long minValue = Long.MAX_VALUE;
        long value = Long.MAX_VALUE;
        List<ExprNode> children = node.getChildren();
        for (int ii = 0; ii < children.size(); ++ii) {
            ExprNode child = children.get(ii);
            Object count = child.get("count");
            if (count == null || (minValue = Math.min(minValue, value = ((Long)count).longValue())) != value) continue;
            minIndex = ii;
        }
        ExprNode minChild = children.get(minIndex);
        ArrayList childEvaluators = new ArrayList(children.size() - 1);
        for (ExprNode child : children) {
            if (child == minChild) continue;
            childEvaluators.add(this.evaluatorBuilder.build(child));
        }
        IndexCursor<?, ServerEntry, ID> childCursor = this.build(minChild);
        return new AndCursor(childCursor, childEvaluators);
    }
}

