/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.tlv.ITLVBerDecoderMBean;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Asn1Decoder
implements ITLVBerDecoderMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Asn1Decoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static final boolean MORE = true;
    private static final boolean END = false;
    private boolean indefiniteLengthAllowed = false;
    private int maxLengthLength = 1;
    private int maxTagLength = 1;

    private boolean treatTagStartState(ByteBuffer stream, IAsn1Container container) {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = new TLV(container.getNewTlvId());
            tlv.setTag(octet);
            container.setCurrentTLV(tlv);
            tlv.setParent(container.getParentTLV());
            container.setState(8);
            if (IS_DEBUG) {
                byte tag = container.getCurrentTLV().getTag();
                LOG.debug("Tag {} has been decoded", (Object)Asn1StringUtils.dumpByte(tag));
            }
            return true;
        }
        return false;
    }

    private void dumpTLVTree(IAsn1Container container) {
        StringBuffer sb = new StringBuffer();
        TLV current = container.getCurrentTLV();
        sb.append("TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        for (current = current.getParent(); current != null; current = current.getParent()) {
            sb.append("-TLV").append(Asn1StringUtils.dumpByte(current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        }
        if (IS_DEBUG) {
            LOG.debug("TLV Tree : {}", (Object)sb.toString());
        }
    }

    private boolean isTLVDecoded(IAsn1Container container) {
        TLV current = container.getCurrentTLV();
        for (TLV parent = current.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getExpectedLength() == 0) continue;
            return false;
        }
        Value value = current.getValue();
        if (value != null && value.getData() != null) {
            return current.getExpectedLength() == value.getData().length;
        }
        return current.getExpectedLength() == 0;
    }

    private boolean treatLengthStartState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = container.getCurrentTLV();
            if ((octet & 0x80) == 0) {
                tlv.setLength(octet);
                tlv.setLengthNbBytes(1);
                container.setState(32);
            } else if ((octet & 0x7F) != 127) {
                int expectedLength = octet & 0x7F;
                if (expectedLength > 4) {
                    LOG.error(I18n.err("ERR_00005", new Object[0]));
                    throw new DecoderException(I18n.err("ERR_00005", new Object[0]));
                }
                tlv.setLength(0);
                tlv.setLengthNbBytes(1 + expectedLength);
                tlv.setLengthBytesRead(1);
                container.setState(16);
            } else {
                LOG.error(I18n.err("ERR_00006", new Object[0]));
                throw new DecoderException(I18n.err("ERR_00006", new Object[0]));
            }
            return true;
        }
        return false;
    }

    private boolean treatLengthPendingState(ByteBuffer stream, IAsn1Container container) {
        if (stream.hasRemaining()) {
            TLV tlv = container.getCurrentTLV();
            int length = tlv.getLength();
            while (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                byte octet = stream.get();
                if (IS_DEBUG) {
                    LOG.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                }
                tlv.incLengthBytesRead();
                length = length << 8 | octet & 0xFF;
                if (stream.hasRemaining()) continue;
                tlv.setLength(length);
                if (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                    container.setState(16);
                    return false;
                }
                container.setState(32);
                return true;
            }
            tlv.setLength(length);
            container.setState(32);
            return true;
        }
        return false;
    }

    private String getParentLength(TLV tlv) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("TLV expected length stack : ");
        while (true) {
            if (tlv == null) break;
            buffer.append(" - ").append(tlv.getExpectedLength());
            tlv = tlv.getParent();
        }
        buffer.append(" - null");
        return buffer.toString();
    }

    private void treatLengthEndState(IAsn1Container container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv == null) {
            LOG.error(I18n.err("ERR_00007", new Object[0]));
            throw new DecoderException(I18n.err("ERR_00007", new Object[0]));
        }
        int length = tlv.getLength();
        TLV parentTLV = container.getParentTLV();
        if (IS_DEBUG) {
            LOG.debug("Parent length : {}", (Object)this.getParentLength(parentTLV));
        }
        if (parentTLV == null) {
            tlv.setExpectedLength(length);
            container.setParentTLV(tlv);
            if (IS_DEBUG) {
                LOG.debug("Root TLV[{}]", length);
            }
        } else {
            int currentLength;
            int expectedLength = parentTLV.getExpectedLength();
            if (expectedLength < (currentLength = tlv.getSize())) {
                LOG.error("tlv[{}, {}]", expectedLength, (Object)currentLength);
                throw new DecoderException(I18n.err("ERR_00008", currentLength, expectedLength));
            }
            if (expectedLength == currentLength) {
                parentTLV.setExpectedLength(0);
                if (tlv.isConstructed()) {
                    if (length == 0) {
                        while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                            parentTLV = parentTLV.getParent();
                        }
                        container.setParentTLV(parentTLV);
                    } else {
                        container.setParentTLV(tlv);
                    }
                    tlv.setParent(parentTLV);
                    tlv.setExpectedLength(length);
                } else {
                    tlv.setExpectedLength(length);
                    while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                        parentTLV = parentTLV.getParent();
                    }
                    container.setParentTLV(parentTLV);
                }
            } else {
                parentTLV.setExpectedLength(expectedLength - currentLength);
                tlv.setExpectedLength(length);
                if (tlv.isConstructed()) {
                    tlv.setParent(parentTLV);
                    container.setParentTLV(tlv);
                }
            }
        }
        if (IS_DEBUG) {
            LOG.debug("Length {} has been decoded", length);
        }
        if (length == 0) {
            container.setState(512);
        } else {
            container.setState(64);
        }
    }

    private boolean treatValueStartState(ByteBuffer stream, IAsn1Container container) {
        TLV currentTlv = container.getCurrentTLV();
        if (TLV.isConstructed(currentTlv.getTag())) {
            container.setState(512);
            return true;
        }
        int length = currentTlv.getLength();
        int nbBytes = stream.remaining();
        if (nbBytes < length) {
            currentTlv.getValue().init(length);
            currentTlv.getValue().setData(stream);
            container.setState(128);
            return false;
        }
        currentTlv.getValue().init(length);
        stream.get(currentTlv.getValue().getData(), 0, length);
        container.setState(512);
        return true;
    }

    private boolean treatValuePendingState(ByteBuffer stream, IAsn1Container container) {
        int nbBytes;
        TLV currentTlv = container.getCurrentTLV();
        int length = currentTlv.getLength();
        int currentLength = currentTlv.getValue().getCurrentLength();
        if (currentLength + (nbBytes = stream.remaining()) < length) {
            currentTlv.getValue().addData(stream);
            container.setState(128);
            return false;
        }
        int remaining = length - currentLength;
        byte[] data = new byte[remaining];
        stream.get(data, 0, remaining);
        currentTlv.getValue().addData(data);
        container.setState(512);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean treatTLVDoneState(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        if (IS_DEBUG) {
            this.dumpTLVTree(container);
        }
        container.getGrammar().executeAction(container);
        if (!this.isTLVDecoded(container)) {
            container.setState(0);
            return stream.hasRemaining();
        }
        if (container.getState() == -1) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        if (container.isGrammarEndAllowed()) {
            container.setState(1024);
            return stream.hasRemaining();
        }
        LOG.error(I18n.err("ERR_00009", new Object[0]));
        throw new DecoderException(I18n.err("ERR_00010", new Object[0]));
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "TAG_STATE_START";
            }
            case 2: {
                return "TAG_STATE_END";
            }
            case 4: {
                return "TAG_STATE_OVERFLOW";
            }
            case 8: {
                return "LENGTH_STATE_START";
            }
            case 16: {
                return "LENGTH_STATE_PENDING";
            }
            case 32: {
                return "LENGTH_STATE_END";
            }
            case 64: {
                return "VALUE_STATE_START";
            }
            case 128: {
                return "VALUE_STATE_PENDING";
            }
            case 512: {
                return "TLV_STATE_DONE";
            }
        }
        return "UNKNOWN_STATE";
    }

    public void decode(ByteBuffer stream, IAsn1Container container) throws DecoderException {
        boolean hasRemaining = stream.hasRemaining();
        container.incrementDecodeBytes(stream.remaining());
        if (container.getDecodeBytes() > container.getMaxPDUSize()) {
            String message = "The PDU current size (" + container.getDecodeBytes() + ") exceeds the maximum allowed PDU size (" + container.getMaxPDUSize() + ")";
            LOG.error(message);
            throw new DecoderException(message);
        }
        if (IS_DEBUG) {
            LOG.debug(">>>==========================================");
            LOG.debug("--> Decoding a PDU");
            LOG.debug(">>>------------------------------------------");
        }
        block11: while (hasRemaining) {
            if (IS_DEBUG) {
                LOG.debug("--- State = {} ---", (Object)this.stateToString(container.getState()));
                if (stream.hasRemaining()) {
                    byte octet = stream.get(stream.position());
                    LOG.debug("  current byte : {}", (Object)Asn1StringUtils.dumpByte(octet));
                } else {
                    LOG.debug("  no more byte to decode in the stream");
                }
            }
            switch (container.getState()) {
                case 0: {
                    container.grammarEndAllowed(false);
                    hasRemaining = this.treatTagStartState(stream, container);
                    continue block11;
                }
                case 8: {
                    hasRemaining = this.treatLengthStartState(stream, container);
                    continue block11;
                }
                case 16: {
                    hasRemaining = this.treatLengthPendingState(stream, container);
                    continue block11;
                }
                case 32: {
                    this.treatLengthEndState(container);
                    continue block11;
                }
                case 64: {
                    hasRemaining = this.treatValueStartState(stream, container);
                    continue block11;
                }
                case 128: {
                    hasRemaining = this.treatValuePendingState(stream, container);
                    continue block11;
                }
                case 256: {
                    hasRemaining = stream.hasRemaining();
                    continue block11;
                }
                case 512: {
                    hasRemaining = this.treatTLVDoneState(stream, container);
                    continue block11;
                }
                case 1024: {
                    LOG.warn("The PDU has been fully decoded but there are still bytes in the buffer.");
                    hasRemaining = false;
                    continue block11;
                }
            }
        }
        if (IS_DEBUG) {
            LOG.debug("<<<------------------------------------------");
            if (container.getState() == 1024) {
                if (container.getCurrentTLV() != null) {
                    LOG.debug("<-- Stop decoding : {}", (Object)container.getCurrentTLV().toString());
                } else {
                    LOG.debug("<-- Stop decoding : null current TLV");
                }
            } else if (container.getCurrentTLV() != null) {
                LOG.debug("<-- End decoding : {}", (Object)container.getCurrentTLV().toString());
            } else {
                LOG.debug("<-- End decoding : null current TLV");
            }
            LOG.debug("<<<==========================================");
        }
    }

    public int getMaxLengthLength() {
        return this.maxLengthLength;
    }

    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    public void disallowIndefiniteLength() {
        this.indefiniteLengthAllowed = false;
    }

    public void allowIndefiniteLength() {
        this.indefiniteLengthAllowed = true;
    }

    public boolean isIndefiniteLengthAllowed() {
        return this.indefiniteLengthAllowed;
    }

    public void setMaxLengthLength(int maxLengthLength) throws DecoderException {
        if (this.indefiniteLengthAllowed && maxLengthLength > 126) {
            throw new DecoderException(I18n.err("ERR_00011", new Object[0]));
        }
        this.maxLengthLength = maxLengthLength;
    }

    public void setMaxTagLength(int maxTagLength) {
        this.maxTagLength = maxTagLength;
    }
}

