/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitEqualityMatchFilterAction
extends GrammarAction {
    private static final Logger log = LoggerFactory.getLogger(InitEqualityMatchFilterAction.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();

    public InitEqualityMatchFilterAction() {
        super("Initialize Equality Match filter");
    }

    public void action(IAsn1Container container) throws DecoderException {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        SearchRequestCodec searchRequest = ldapMessageContainer.getSearchRequest();
        AttributeValueAssertionFilter filter = new AttributeValueAssertionFilter(ldapMessageContainer.getTlvId(), 0);
        searchRequest.addCurrentFilter(filter);
        searchRequest.setTerminalFilter(filter);
        if (IS_DEBUG) {
            log.debug("Initialize Equality Match filter");
        }
    }
}

