/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.util.Strings;

public class AttributeTypeOptions {
    private AttributeType attributeType;
    private Set<String> options;

    public AttributeTypeOptions(AttributeType attributeType) {
        this.attributeType = attributeType;
    }

    public AttributeTypeOptions(AttributeType attributeType, Set<String> options) {
        this.attributeType = attributeType;
        this.options = options;
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public boolean hasOption() {
        return this.options != null && this.options.size() != 0;
    }

    public boolean hasOption(String option) {
        if (this.hasOption()) {
            return this.options.contains(Strings.toLowerCaseAscii(Strings.trim(option)));
        }
        return false;
    }

    public void addOption(String option) {
        if (this.options == null) {
            this.options = new HashSet<String>();
        }
        this.options.add(Strings.toLowerCaseAscii(Strings.trim(option)));
    }

    public void addOptions(Set<String> optionsToAdd) {
        if (this.options == null) {
            this.options = optionsToAdd;
        } else {
            this.options.addAll(optionsToAdd);
        }
    }

    public int hashCode() {
        return this.attributeType.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeTypeOptions)) {
            return false;
        }
        AttributeTypeOptions that = (AttributeTypeOptions)o;
        return this.attributeType.equals(that.attributeType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<").append(this.attributeType.getName());
        if (this.hasOption()) {
            for (String option : this.options) {
                sb.append(";").append(option);
            }
        }
        return sb.append(">").toString();
    }
}

