/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import jdbm.RecordManager;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.api.ldap.model.cursor.AbstractCursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.filtering.EntryFilter;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedEntryCursor
extends AbstractCursor<Entry>
implements EntryFilteringCursor {
    private static final Logger LOG = LoggerFactory.getLogger(SortedEntryCursor.class);
    private TupleBrowser browser;
    private final Tuple tuple = new Tuple();
    private RecordManager recMan;
    private File dataFile;
    private BTree<Entry, String> btree;

    public SortedEntryCursor(BTree<Entry, String> btree, RecordManager recMan, File dataFile) throws IOException {
        this.recMan = recMan;
        this.dataFile = dataFile;
        this.btree = btree;
        this.browser = btree.browse();
    }

    @Override
    public boolean available() {
        return this.tuple.getKey() != null;
    }

    @Override
    public void before(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void after(Entry element) throws LdapException, CursorException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        try {
            this.clearValue();
            this.browser = this.btree.browse();
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        try {
            this.clearValue();
            this.browser = this.btree.browse(null);
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        try {
            if (this.browser == null) {
                this.browser = this.btree.browse(null);
            }
            if (this.browser.getPrevious(this.tuple)) {
                return true;
            }
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        try {
            if (this.browser == null) {
                this.browser = this.btree.browse();
            }
            if (this.browser.getNext(this.tuple)) {
                return true;
            }
        }
        catch (IOException e) {
            throw new CursorException(e);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        this.clearValue();
        return false;
    }

    @Override
    public Entry get() throws CursorException {
        if (this.tuple.getKey() == null) {
            throw new InvalidCursorPositionException();
        }
        return (Entry)this.tuple.getKey();
    }

    @Override
    public void close() throws IOException {
        this.deleteFile();
        super.close();
    }

    @Override
    public void close(Exception cause) throws IOException {
        this.deleteFile();
        super.close(cause);
    }

    @Override
    public boolean addEntryFilter(EntryFilter filter) {
        return false;
    }

    @Override
    public List<EntryFilter> getEntryFilters() {
        return null;
    }

    @Override
    public SearchOperationContext getOperationContext() {
        return null;
    }

    private void clearValue() {
        this.tuple.setKey(null);
        this.tuple.setValue(null);
    }

    private void deleteFile() {
        if (this.recMan == null) {
            return;
        }
        try {
            this.recMan.close();
            this.dataFile.delete();
        }
        catch (IOException e) {
            LOG.warn("Failed to delete the sorted entry data file {}", (Object)this.dataFile, (Object)e);
        }
    }
}

