/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.changelog;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultEntry;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.ldif.ChangeType;
import org.apache.directory.api.ldap.model.ldif.LdifEntry;
import org.apache.directory.api.ldap.model.ldif.LdifRevertor;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.controls.ManageDsaITImpl;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.server.core.api.CoreSession;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.changelog.ChangeLog;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.entry.ServerEntryUtils;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.shared.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeLogInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ChangeLogInterceptor.class);
    private AttributeType entryDeleted;
    private ChangeLog changeLog;
    private static final String REV_AT_OID = "1.3.6.1.4.1.18060.0.4.1.2.47";

    public ChangeLogInterceptor() {
        super(InterceptorEnum.CHANGE_LOG_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.changeLog = directoryService.getChangeLog();
        this.entryDeleted = directoryService.getSchemaManager().getAttributeType("1.3.6.1.4.1.18060.0.4.1.2.31");
    }

    public void add(AddOperationContext addContext) throws LdapException {
        this.next(addContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        Entry addEntry = addContext.getEntry();
        if (addEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Add);
        forward.setDn(addContext.getDn());
        for (Attribute attribute : addEntry.getAttributes()) {
            AttributeType attributeType = attribute.getAttributeType();
            forward.addAttribute(addEntry.get(attributeType).clone());
        }
        LdifEntry reverse = LdifRevertor.reverseAdd((Dn)addContext.getDn());
        addContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)addContext), forward, reverse));
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Entry serverEntry = null;
        if (this.changeLog.isEnabled()) {
            serverEntry = this.getAttributes((OperationContext)deleteContext);
        }
        this.next(deleteContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        if (serverEntry.get(REV_AT_OID) != null) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Delete);
        forward.setDn(deleteContext.getDn());
        DefaultEntry reverseEntry = new DefaultEntry(serverEntry.getDn());
        boolean isCollectiveSubentry = serverEntry.hasObjectClass(new String[]{"collectiveAttributeSubentry"});
        for (Attribute attribute : serverEntry) {
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
            if (at.isCollective() && !isCollectiveSubentry) continue;
            reverseEntry.add(new Attribute[]{attribute.clone()});
        }
        LdifEntry reverse = LdifRevertor.reverseDel((Dn)deleteContext.getDn(), (Entry)reverseEntry);
        deleteContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)deleteContext), forward, reverse));
    }

    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        boolean isDelete;
        Entry serverEntry = null;
        Modification modification = ServerEntryUtils.getModificationItem((List)modifyContext.getModItems(), (AttributeType)this.entryDeleted);
        boolean bl = isDelete = modification != null;
        if (!isDelete && this.changeLog.isEnabled()) {
            serverEntry = this.getAttributes((OperationContext)modifyContext);
        }
        ArrayList<Modification> clonedMods = new ArrayList<Modification>();
        for (Modification mod : modifyContext.getModItems()) {
            clonedMods.add(mod.clone());
        }
        this.next(modifyContext);
        if (isDelete || !this.changeLog.isEnabled() || modifyContext.getModItems().size() == 0) {
            if (isDelete) {
                LOG.debug("Bypassing changelog on modify of entryDeleted attribute.");
            }
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.Modify);
        forward.setDn(modifyContext.getDn());
        ArrayList<Modification> mods = new ArrayList<Modification>(clonedMods.size());
        for (Modification modification2 : clonedMods) {
            mods.add(modification2);
            forward.addModification(modification2);
        }
        DefaultEntry clientEntry = new DefaultEntry(serverEntry.getDn());
        for (Attribute attribute : serverEntry) {
            clientEntry.add(new Attribute[]{attribute.clone()});
        }
        LdifEntry ldifEntry = LdifRevertor.reverseModify((Dn)modifyContext.getDn(), mods, (Entry)clientEntry);
        modifyContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)modifyContext), forward, ldifEntry));
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        this.next(moveContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(moveContext.getDn());
        forward.setNewSuperior(moveContext.getNewSuperior().getName());
        LdifEntry reverse = LdifRevertor.reverseMove((Dn)moveContext.getNewSuperior(), (Dn)moveContext.getDn());
        moveContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)moveContext), forward, reverse));
    }

    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        Entry serverEntry = null;
        if (this.changeLog.isEnabled()) {
            serverEntry = moveAndRenameContext.getOriginalEntry();
        }
        this.next(moveAndRenameContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModDn);
        forward.setDn(moveAndRenameContext.getDn());
        forward.setDeleteOldRdn(moveAndRenameContext.getDeleteOldRdn());
        forward.setNewRdn(moveAndRenameContext.getNewRdn().getName());
        forward.setNewSuperior(moveAndRenameContext.getNewSuperiorDn().getName());
        List reverses = LdifRevertor.reverseMoveAndRename((Entry)serverEntry, (Dn)moveAndRenameContext.getNewSuperiorDn(), (Rdn)moveAndRenameContext.getNewRdn(), (boolean)false);
        if (moveAndRenameContext.isReferralIgnored()) {
            forward.addControl(new Control[]{new ManageDsaITImpl()});
            LdifEntry reversedEntry = (LdifEntry)reverses.get(0);
            reversedEntry.addControl(new Control[]{new ManageDsaITImpl()});
        }
        moveAndRenameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)moveAndRenameContext), forward, reverses));
    }

    public void rename(RenameOperationContext renameContext) throws LdapException {
        Entry serverEntry = null;
        if (renameContext.getEntry() != null) {
            serverEntry = ((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry();
        }
        this.next(renameContext);
        if (!this.changeLog.isEnabled()) {
            return;
        }
        LdifEntry forward = new LdifEntry();
        forward.setChangeType(ChangeType.ModRdn);
        forward.setDn(renameContext.getDn());
        forward.setNewRdn(renameContext.getNewRdn().getName());
        forward.setDeleteOldRdn(renameContext.getDeleteOldRdn());
        List reverses = LdifRevertor.reverseRename((Entry)serverEntry, (Rdn)renameContext.getNewRdn(), (boolean)renameContext.getDeleteOldRdn());
        renameContext.setChangeLogEvent(this.changeLog.log(ChangeLogInterceptor.getPrincipal((OperationContext)renameContext), forward, reverses));
    }

    private Entry getAttributes(OperationContext opContext) throws LdapException {
        Dn dn = opContext.getDn();
        if (dn.equals((Object)"cn=schema")) {
            return SchemaService.getSubschemaEntryCloned((DirectoryService)this.directoryService);
        }
        CoreSession session = opContext.getSession();
        LookupOperationContext lookupContext = new LookupOperationContext(session, dn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry serverEntry = this.directoryService.getPartitionNexus().lookup(lookupContext);
        return serverEntry;
    }
}

