/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.referral;

import org.apache.directory.api.ldap.model.constants.SchemaConstants;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.url.LdapUrl;
import org.apache.directory.api.util.Strings;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.ReferralManager;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.partition.PartitionNexus;
import org.apache.directory.server.core.shared.ReferralManagerImpl;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferralInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ReferralInterceptor.class);
    private PartitionNexus nexus;
    private ReferralManager referralManager;
    private Dn subschemaSubentryDn;

    private static void checkRefAttributeValue(Value<?> value) throws LdapException, LdapURLEncodingException {
        StringValue ref = (StringValue)value;
        String refVal = ref.getString();
        LdapUrl ldapUrl = new LdapUrl(refVal);
        if (ldapUrl.getScope() != SearchScope.OBJECT) {
            String message = I18n.err((I18n)I18n.ERR_36, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (!Strings.isEmpty((String)ldapUrl.getFilter())) {
            String message = I18n.err((I18n)I18n.ERR_37, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getAttributes() != null && ldapUrl.getAttributes().size() != 0) {
            String message = I18n.err((I18n)I18n.ERR_38, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err((I18n)I18n.ERR_39, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        if (ldapUrl.getExtensions() != null && ldapUrl.getExtensions().size() != 0) {
            String message = I18n.err((I18n)I18n.ERR_40, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        Dn dn = ldapUrl.getDn();
        if (dn == null || dn.isEmpty()) {
            String message = I18n.err((I18n)I18n.ERR_41, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
    }

    private boolean isReferral(Entry entry) throws LdapException {
        if (entry == null) {
            return false;
        }
        Attribute oc = entry.get(this.directoryService.getAtProvider().getObjectClass());
        if (oc == null) {
            LOG.warn("could not find objectClass attribute in entry: " + entry);
            return false;
        }
        if (!oc.contains(new String[]{"referral"})) {
            return false;
        }
        Attribute refAttr = entry.get("ref");
        if (refAttr == null) {
            String message = I18n.err((I18n)I18n.ERR_42, (Object[])new Object[0]);
            LOG.error(message);
            throw new LdapException(message);
        }
        for (Value value : refAttr) {
            try {
                ReferralInterceptor.checkRefAttributeValue(value);
            }
            catch (LdapURLEncodingException ldapURLEncodingException) {}
        }
        return true;
    }

    public ReferralInterceptor() {
        super(InterceptorEnum.REFERRAL_INTERCEPTOR);
    }

    public void init(DirectoryService directoryService) throws LdapException {
        super.init(directoryService);
        this.nexus = directoryService.getPartitionNexus();
        this.referralManager = new ReferralManagerImpl(directoryService);
        directoryService.setReferralManager(this.referralManager);
        Value subschemaSubentry = this.nexus.getRootDseValue(directoryService.getAtProvider().getSubschemaSubentry());
        this.subschemaSubentryDn = this.dnFactory.create(subschemaSubentry.getString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(AddOperationContext addContext) throws LdapException {
        Entry entry = addContext.getEntry();
        boolean isReferral = this.isReferral(entry);
        this.next(addContext);
        if (isReferral) {
            this.referralManager.lockWrite();
            try {
                this.referralManager.addReferral(entry);
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }

    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        this.next(deleteContext);
        Entry entry = deleteContext.getEntry();
        if (entry != null && this.isReferral(entry)) {
            this.referralManager.lockWrite();
            try {
                this.referralManager.removeReferral(entry);
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        Dn dn = modifyContext.getDn();
        this.next(modifyContext);
        if (dn.isEmpty() || dn.equals((Object)this.subschemaSubentryDn)) {
            return;
        }
        LookupOperationContext lookupContext = new LookupOperationContext(modifyContext.getSession(), dn, SchemaConstants.ALL_ATTRIBUTES_ARRAY);
        Entry newEntry = this.nexus.lookup(lookupContext);
        if (newEntry != null) {
            this.referralManager.lockWrite();
            try {
                if (this.referralManager.isReferral(newEntry.getDn())) {
                    this.referralManager.removeReferral(modifyContext.getEntry());
                    this.referralManager.addReferral(newEntry);
                }
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }

    public void move(MoveOperationContext moveContext) throws LdapException {
        boolean isReferral = this.isReferral(moveContext.getOriginalEntry());
        this.next(moveContext);
        if (isReferral) {
            this.referralManager.lockWrite();
            try {
                this.referralManager.addReferral(moveContext.getModifiedEntry());
                this.referralManager.removeReferral(moveContext.getOriginalEntry());
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        boolean isReferral = this.isReferral(moveAndRenameContext.getOriginalEntry());
        this.next(moveAndRenameContext);
        if (isReferral) {
            Entry newEntry = moveAndRenameContext.getModifiedEntry();
            this.referralManager.lockWrite();
            try {
                this.referralManager.addReferral(newEntry);
                this.referralManager.removeReferral(moveAndRenameContext.getOriginalEntry());
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(RenameOperationContext renameContext) throws LdapException {
        boolean isReferral = this.isReferral(renameContext.getOriginalEntry());
        this.next(renameContext);
        if (isReferral) {
            LookupOperationContext lookupContext = new LookupOperationContext(renameContext.getSession(), renameContext.getNewDn(), SchemaConstants.ALL_ATTRIBUTES_ARRAY);
            Entry newEntry = this.nexus.lookup(lookupContext);
            this.referralManager.lockWrite();
            try {
                this.referralManager.addReferral(newEntry);
                this.referralManager.removeReferral(((ClonedServerEntry)renameContext.getEntry()).getOriginalEntry());
            }
            finally {
                this.referralManager.unlock();
            }
        }
    }
}

