/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.util.Comparator;
import jdbm.btree.BTree;
import jdbm.helper.Tuple;
import jdbm.helper.TupleBrowser;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBTreeCursor<E>
extends AbstractCursor<E> {
    private final Tuple tuple = new Tuple();
    private final BTree btree;
    private final Comparator<E> comparator;
    private boolean valueAvailable;
    private TupleBrowser browser;

    public KeyBTreeCursor(BTree btree, Comparator<E> comparator) throws Exception {
        this.btree = btree;
        this.comparator = comparator;
    }

    private void clearValue() {
        this.tuple.setKey(null);
        this.tuple.setValue(null);
        this.valueAvailable = false;
    }

    public boolean available() {
        return this.valueAvailable;
    }

    public void before(E element) throws Exception {
        this.checkNotClosed("before()");
        this.browser = this.btree.browse(element);
        this.clearValue();
    }

    public void after(E element) throws Exception {
        this.browser = this.btree.browse(element);
        while (this.browser.getNext(this.tuple)) {
            this.checkNotClosed("after()");
            Object next = this.tuple.getKey();
            int nextCompared = this.comparator.compare(next, element);
            if (nextCompared <= 0) continue;
            this.browser.getPrevious(this.tuple);
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.browser = this.btree.browse();
        this.clearValue();
    }

    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.browser = this.btree.browse(null);
    }

    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.browser = this.btree.browse(null);
        }
        if (this.browser.getPrevious(this.tuple)) {
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.browser == null) {
            this.browser = this.btree.browse();
        }
        if (this.browser.getNext(this.tuple)) {
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    public E get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return (E)this.tuple.getKey();
        }
        throw new InvalidCursorPositionException();
    }
}

