/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.directory.server.core.event.EventType;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapApiService;
import org.apache.directory.shared.ldap.codec.api.LdapApiServiceFactory;
import org.apache.directory.shared.ldap.extras.controls.SyncModifyDnType;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnDecorator;
import org.apache.directory.shared.ldap.model.entry.Attribute;
import org.apache.directory.shared.ldap.model.entry.DefaultAttribute;
import org.apache.directory.shared.ldap.model.entry.DefaultEntry;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaEventMessage
implements Externalizable {
    private EventType eventType;
    private Entry entry;
    private SyncModifyDnDecorator modDnControl;
    private static final Logger LOG = LoggerFactory.getLogger(ReplicaEventMessage.class);
    private static SchemaManager schemaManager;
    private LdapApiService codec;

    public ReplicaEventMessage() {
        this.codec = LdapApiServiceFactory.getSingleton();
    }

    public ReplicaEventMessage(EventType eventType, Entry entry) {
        this.eventType = eventType;
        this.entry = entry;
    }

    public ReplicaEventMessage(SyncModifyDnDecorator modDnControl, Entry entry) {
        this.codec = LdapApiServiceFactory.getSingleton();
        this.modDnControl = modDnControl;
        this.entry = entry;
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public Entry getEntry() {
        return this.entry;
    }

    public SyncModifyDnDecorator getModDnControl() {
        return this.modDnControl;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte b = in.readByte();
        if (b == 0) {
            SyncModifyDnType modDnType = SyncModifyDnType.getModifyDnType((int)in.readShort());
            this.modDnControl = new SyncModifyDnDecorator(this.codec);
            this.modDnControl.setModDnType(modDnType);
            this.modDnControl.setEntryDn(in.readUTF());
            switch (modDnType) {
                case MOVE: {
                    this.modDnControl.setNewSuperiorDn(in.readUTF());
                    break;
                }
                case RENAME: {
                    this.modDnControl.setNewRdn(in.readUTF());
                    this.modDnControl.setDeleteOldRdn(in.readBoolean());
                    break;
                }
                case MOVEANDRENAME: {
                    this.modDnControl.setNewSuperiorDn(in.readUTF());
                    this.modDnControl.setNewRdn(in.readUTF());
                    this.modDnControl.setDeleteOldRdn(in.readBoolean());
                }
            }
        } else {
            this.eventType = EventType.getType((int)in.readShort());
        }
        this.entry = new DefaultEntry(schemaManager);
        Dn dn = null;
        try {
            dn = new Dn(schemaManager);
            dn.readExternal(in);
        }
        catch (ClassNotFoundException cnfe) {
            IOException ioe = new IOException(cnfe.getMessage());
            ioe.initCause(cnfe);
            throw ioe;
        }
        this.entry.setDn(dn);
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            String oid = in.readUTF();
            try {
                AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(oid);
                DefaultAttribute attribute = new DefaultAttribute(attributeType);
                attribute.readExternal(in);
                this.entry.add(new Attribute[]{attribute});
                continue;
            }
            catch (Exception ne) {
                this.entry = null;
                LOG.warn(I18n.err((I18n)I18n.ERR_04470, (Object[])new Object[]{oid}));
            }
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.eventType == null) {
            out.writeByte(0);
            SyncModifyDnType modDnType = this.modDnControl.getModDnType();
            out.writeShort(modDnType.getValue());
            out.writeUTF(this.modDnControl.getEntryDn());
            switch (modDnType) {
                case MOVE: {
                    out.writeUTF(this.modDnControl.getNewSuperiorDn());
                    break;
                }
                case RENAME: {
                    out.writeUTF(this.modDnControl.getNewRdn());
                    out.writeBoolean(this.modDnControl.isDeleteOldRdn());
                    break;
                }
                case MOVEANDRENAME: {
                    out.writeUTF(this.modDnControl.getNewSuperiorDn());
                    out.writeUTF(this.modDnControl.getNewRdn());
                    out.writeBoolean(this.modDnControl.isDeleteOldRdn());
                }
            }
        } else {
            out.writeByte(1);
            out.writeShort(this.eventType.getMask());
        }
        this.entry.getDn().writeExternal(out);
        out.writeInt(this.entry.size());
        for (DefaultAttribute attribute : this.entry) {
            out.writeUTF(attribute.getAttributeType().getOid());
            attribute.writeExternal(out);
        }
    }

    public static void setSchemaManager(SchemaManager schemaManager) {
        ReplicaEventMessage.schemaManager = schemaManager;
    }
}

