/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.filter.AndNode;
import org.apache.directory.shared.ldap.model.filter.ExprNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndEvaluator<ID>
implements Evaluator<AndNode, Entry, ID> {
    private final List<Evaluator<? extends ExprNode, Entry, ID>> evaluators;
    private final AndNode node;

    public AndEvaluator(AndNode node, List<Evaluator<? extends ExprNode, Entry, ID>> evaluators) {
        this.node = node;
        this.evaluators = this.optimize(evaluators);
    }

    private List<Evaluator<? extends ExprNode, Entry, ID>> optimize(List<Evaluator<? extends ExprNode, Entry, ID>> unoptimized) {
        ArrayList<Evaluator<ExprNode, Entry, ID>> optimized = new ArrayList<Evaluator<ExprNode, Entry, ID>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new Comparator<Evaluator<?, Entry, ID>>(){

            @Override
            public int compare(Evaluator<?, Entry, ID> e1, Evaluator<?, Entry, ID> e2) {
                long scanCount2;
                long scanCount1 = (Long)e1.getExpression().get((Object)"count");
                if (scanCount1 == (scanCount2 = ((Long)e2.getExpression().get((Object)"count")).longValue())) {
                    return 0;
                }
                if (scanCount1 < scanCount2) {
                    return -1;
                }
                return 1;
            }
        });
        return optimized;
    }

    @Override
    public boolean evaluateId(ID id) throws Exception {
        for (Evaluator<ExprNode, Entry, ID> evaluator : this.evaluators) {
            if (evaluator.evaluateId(id)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluateEntry(Entry entry) throws Exception {
        for (Evaluator<ExprNode, Entry, ID> evaluator : this.evaluators) {
            if (evaluator.evaluateEntry(entry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean evaluate(IndexEntry<?, Entry, ID> indexEntry) throws Exception {
        for (Evaluator<ExprNode, Entry, ID> evaluator : this.evaluators) {
            if (evaluator.evaluate(indexEntry)) continue;
            return false;
        }
        return true;
    }

    @Override
    public AndNode getExpression() {
        return this.node;
    }
}

