/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2.reponse;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.dsmlv2.AbstractGrammar;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.Dsmlv2StatesEnum;
import org.apache.directory.shared.dsmlv2.GrammarAction;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.IGrammar;
import org.apache.directory.shared.dsmlv2.ParserUtils;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.dsmlv2.reponse.BatchResponse;
import org.apache.directory.shared.dsmlv2.reponse.ErrorResponse;
import org.apache.directory.shared.dsmlv2.reponse.SearchResponse;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapResponseCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Dsmlv2ResponseGrammar
extends AbstractGrammar
implements IGrammar {
    private static Dsmlv2ResponseGrammar instance = new Dsmlv2ResponseGrammar();
    private static Set<String> DSMLV2_DESCR_TAGS = null;
    private final GrammarAction batchResponseCreation = new GrammarAction("Create Batch Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BatchResponse batchResponse = new BatchResponse();
            container.setBatchResponse(batchResponse);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                batchResponse.setRequestID(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
        }
    };
    private final GrammarAction addResponseCreation = new GrammarAction("Create Add Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            AddResponseCodec addResponse = new AddResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)addResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            addResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                addResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction authResponseCreation = new GrammarAction("Create Auth Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            BindResponseCodec bindResponse = new BindResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)bindResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            bindResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                bindResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction compareResponseCreation = new GrammarAction("Create Compare Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            CompareResponseCodec compareResponse = new CompareResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)compareResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            compareResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                compareResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction delResponseCreation = new GrammarAction("Create Del Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            DelResponseCodec delResponse = new DelResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)delResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            delResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                delResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction modifyResponseCreation = new GrammarAction("Create Modify Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyResponseCodec modifyResponse = new ModifyResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)modifyResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            modifyResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction modDNResponseCreation = new GrammarAction("Create Mod DN Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ModifyDNResponseCodec modifyDNResponse = new ModifyDNResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)modifyDNResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            modifyDNResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                modifyDNResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction extendedResponseCreation = new GrammarAction("Create Extended Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponseCodec extendedResponse = new ExtendedResponseCodec();
            container.getBatchResponse().addResponse((LdapResponseCodec)extendedResponse);
            LdapResultCodec ldapResult = new LdapResultCodec();
            extendedResponse.setLdapResult(ldapResult);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                extendedResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    ldapResult.setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction errorResponseCreation = new GrammarAction("Create Error Response"){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ErrorResponse errorResponse = new ErrorResponse();
            container.getBatchResponse().addResponse(errorResponse);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                errorResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "type")) == null) throw new XmlPullParserException(I18n.err((String)"ERR_03005", (Object[])new Object[0]), xpp, null);
            if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.NOT_ATTEMPTED))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.NOT_ATTEMPTED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.COULD_NOT_CONNECT);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.CONNECTION_CLOSED))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.CONNECTION_CLOSED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.MALFORMED_REQUEST))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.MALFORMED_REQUEST);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.GATEWAY_INTERNAL_ERROR);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.AUTHENTICATION_FAILED))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.AUTHENTICATION_FAILED);
                return;
            } else if (attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.UNRESOLVABLE_URI))) {
                errorResponse.setType(ErrorResponse.ErrorResponseType.UNRESOLVABLE_URI);
                return;
            } else {
                if (!attributeValue.equals(errorResponse.getTypeDescr(ErrorResponse.ErrorResponseType.OTHER))) throw new XmlPullParserException(I18n.err((String)"ERR_03004", (Object[])new Object[0]), xpp, null);
                errorResponse.setType(ErrorResponse.ErrorResponseType.OTHER);
            }
        }
    };
    private final GrammarAction errorResponseAddMessage = new GrammarAction("Add Message to Error Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ErrorResponse errorResponse = (ErrorResponse)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    errorResponse.setMessage(nextText.trim());
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction errorResponseAddDetail = null;
    private final GrammarAction ldapResultControlCreation = new GrammarAction("Create Control for LDAP Result"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            LdapResponseCodec ldapResponse = container.getBatchResponse().getCurrentResponse();
            if (ldapResponse instanceof SearchResponse) {
                ldapResponse = ((SearchResponse)ldapResponse).getSearchResultDone();
            }
            Dsmlv2ResponseGrammar.this.createAndAddControl(container, (LdapMessageCodec)ldapResponse);
        }
    };
    private final GrammarAction searchResultEntryControlCreation = new GrammarAction("Create Control for Search Result Entry"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultEntryCodec ldapMessage = ((SearchResponse)container.getBatchResponse().getCurrentResponse()).getCurrentSearchResultEntry();
            Dsmlv2ResponseGrammar.this.createAndAddControl(container, (LdapMessageCodec)ldapMessage);
        }
    };
    private final GrammarAction searchResultReferenceControlCreation = new GrammarAction("Create Control for Search Result Reference"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultReferenceCodec ldapMessage = ((SearchResponse)container.getBatchResponse().getCurrentResponse()).getCurrentSearchResultReference();
            Dsmlv2ResponseGrammar.this.createAndAddControl(container, (LdapMessageCodec)ldapMessage);
        }
    };
    private final GrammarAction ldapResultControlValueCreation = new GrammarAction("Add ControlValue to Control for LDAP Result"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            LdapResponseCodec ldapResponse = container.getBatchResponse().getCurrentResponse();
            if (ldapResponse instanceof SearchResponse) {
                ldapResponse = ((SearchResponse)ldapResponse).getSearchResultDone();
            }
            Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, (LdapMessageCodec)ldapResponse);
        }
    };
    private final GrammarAction searchResultEntryControlValueCreation = new GrammarAction("Add ControlValue to Control for Search Result Entry"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultEntryCodec ldapMessage = ((SearchResponse)container.getBatchResponse().getCurrentResponse()).getCurrentSearchResultEntry();
            Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, (LdapMessageCodec)ldapMessage);
        }
    };
    private final GrammarAction searchResultReferenceControlValueCreation = new GrammarAction("Add ControlValue to Control for Search Result Entry"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultReferenceCodec ldapMessage = ((SearchResponse)container.getBatchResponse().getCurrentResponse()).getCurrentSearchResultReference();
            Dsmlv2ResponseGrammar.this.createAndAddControlValue(container, (LdapMessageCodec)ldapMessage);
        }
    };
    private final GrammarAction ldapResultAddResultCode = new GrammarAction("Add ResultCode to LDAP Result"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            LdapResponseCodec ldapResponse = container.getBatchResponse().getCurrentResponse();
            LdapResultCodec ldapResult = null;
            if (ldapResponse instanceof SearchResponse) {
                SearchResponse searchResponse = (SearchResponse)ldapResponse;
                ldapResult = searchResponse.getSearchResultDone().getLdapResult();
            } else {
                ldapResult = ldapResponse.getLdapResult();
            }
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "code");
            if (attributeValue != null) {
                try {
                    ldapResult.setResultCode(ResultCodeEnum.getResultCode((int)Integer.parseInt(attributeValue)));
                }
                catch (NumberFormatException e) {
                    throw new XmlPullParserException(I18n.err((String)"ERR_03009", (Object[])new Object[0]), xpp, null);
                }
            } else {
                throw new XmlPullParserException(I18n.err((String)"ERR_03010", (Object[])new Object[0]), xpp, null);
            }
            attributeValue = xpp.getAttributeValue("", "descr");
            if (attributeValue != null && !DSMLV2_DESCR_TAGS.contains(attributeValue)) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03011", (Object[])new Object[]{attributeValue}), xpp, null);
            }
        }
    };
    private final GrammarAction ldapResultAddErrorMessage = new GrammarAction("Add Error Message to LDAP Result"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            LdapResponseCodec ldapResponse = container.getBatchResponse().getCurrentResponse();
            LdapResultCodec ldapResult = null;
            if (ldapResponse instanceof SearchResponse) {
                SearchResponse searchResponse = (SearchResponse)ldapResponse;
                ldapResult = searchResponse.getSearchResultDone().getLdapResult();
            } else {
                ldapResult = ldapResponse.getLdapResult();
            }
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    ldapResult.setErrorMessage(nextText.trim());
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
            }
        }
    };
    private final GrammarAction ldapResultAddReferral = new GrammarAction("Add Referral to LDAP Result"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            block7: {
                LdapResponseCodec ldapResponse = container.getBatchResponse().getCurrentResponse();
                LdapResultCodec ldapResult = null;
                if (ldapResponse instanceof SearchResponse) {
                    SearchResponse searchResponse = (SearchResponse)ldapResponse;
                    ldapResult = searchResponse.getSearchResultDone().getLdapResult();
                } else {
                    ldapResult = ldapResponse.getLdapResult();
                }
                if (ldapResult.getReferrals() == null) {
                    ldapResult.initReferrals();
                }
                XmlPullParser xpp = container.getParser();
                try {
                    String nextText = xpp.nextText();
                    if (nextText.equals("")) break block7;
                    try {
                        ldapResult.addReferral(new LdapURL(nextText.trim()));
                    }
                    catch (LdapURLEncodingException e) {
                        throw new XmlPullParserException(e.getMessage(), xpp, null);
                    }
                }
                catch (IOException e) {
                    throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
                }
            }
        }
    };
    private final GrammarAction searchResponseCreation = new GrammarAction("Create Search Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = new SearchResponse();
            container.getBatchResponse().addResponse(searchResponse);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResponse.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
        }
    };
    private final GrammarAction searchResultEntryCreation = new GrammarAction("Add Search Result Entry to Search Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultEntryCodec searchResultEntry = new SearchResultEntryCodec();
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            searchResponse.addSearchResultEntry(searchResultEntry);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultEntry.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "dn")) != null) {
                try {
                    searchResultEntry.setObjectName(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException(e.getMessage(), xpp, null);
                }
            } else {
                throw new XmlPullParserException("dn attribute is required", xpp, null);
            }
        }
    };
    private final GrammarAction searchResultReferenceCreation = new GrammarAction("Add Search Result Reference to Search Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultReferenceCodec searchResultReference = new SearchResultReferenceCodec();
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            searchResponse.addSearchResultReference(searchResultReference);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultReference.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
        }
    };
    private final GrammarAction searchResultDoneCreation = new GrammarAction("Add Search Result Done to Search Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResultDoneCodec searchResultDone = new SearchResultDoneCodec();
            searchResultDone.setLdapResult(new LdapResultCodec());
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            searchResponse.setSearchResultDone(searchResultDone);
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "requestID");
            if (attributeValue != null) {
                searchResultDone.setMessageId(ParserUtils.parseAndVerifyRequestID(attributeValue, xpp));
            }
            if ((attributeValue = xpp.getAttributeValue("", "matchedDN")) != null) {
                try {
                    searchResultDone.getLdapResult().setMatchedDN(new DN(attributeValue));
                }
                catch (LdapInvalidDnException e) {
                    throw new XmlPullParserException("" + e.getMessage(), xpp, null);
                }
            }
        }
    };
    private final GrammarAction searchResultEntryAddAttr = new GrammarAction("Add Attr to Search Result Entry"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            SearchResultEntryCodec searchResultEntry = searchResponse.getCurrentSearchResultEntry();
            XmlPullParser xpp = container.getParser();
            String attributeValue = xpp.getAttributeValue("", "name");
            if (attributeValue == null) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03012", (Object[])new Object[0]), xpp, null);
            }
            searchResultEntry.addAttributeValues(attributeValue);
        }
    };
    private final GrammarAction searchResultEntryAddValue = new GrammarAction("Add a Value to an Attr of a Search Result Entry"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            SearchResultEntryCodec searchResultEntry = searchResponse.getCurrentSearchResultEntry();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    searchResultEntry.addAttributeValue((Object)Base64.decode((char[])nextText.toCharArray()));
                } else {
                    searchResultEntry.addAttributeValue((Object)nextText);
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
            }
        }
    };
    private final GrammarAction searchResultReferenceAddRef = new GrammarAction("Add a Ref to a Search Result Reference"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            SearchResponse searchResponse = (SearchResponse)container.getBatchResponse().getCurrentResponse();
            SearchResultReferenceCodec searchResultReference = searchResponse.getCurrentSearchResultReference();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    searchResultReference.addSearchResultReference(new LdapURL(nextText));
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
            }
            catch (LdapURLEncodingException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction extendedResponseAddResultCode = this.ldapResultAddResultCode;
    private final GrammarAction extendedResponseAddErrorMessage = this.ldapResultAddErrorMessage;
    private final GrammarAction extendedResponseAddReferral = this.ldapResultAddReferral;
    private final GrammarAction extendedResponseAddResponseName = new GrammarAction("Add Response Name to Extended Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponseCodec extendedResponse = (ExtendedResponseCodec)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String nextText = xpp.nextText();
                if (!nextText.equals("")) {
                    extendedResponse.setResponseName(new OID(nextText.trim()));
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
            }
            catch (DecoderException e) {
                throw new XmlPullParserException(e.getMessage(), xpp, null);
            }
        }
    };
    private final GrammarAction extendedResponseAddResponse = new GrammarAction("Add Response to Extended Response"){

        public void action(Dsmlv2Container container) throws XmlPullParserException {
            ExtendedResponseCodec extendedResponse = (ExtendedResponseCodec)container.getBatchResponse().getCurrentResponse();
            XmlPullParser xpp = container.getParser();
            try {
                String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
                String nextText = xpp.nextText();
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    extendedResponse.setResponse((Object)Base64.decode((char[])nextText.trim().toCharArray()));
                } else {
                    extendedResponse.setResponse((Object)nextText.trim());
                }
            }
            catch (IOException e) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
            }
        }
    };

    private Dsmlv2ResponseGrammar() {
        this.name = Dsmlv2ResponseGrammar.class.getName();
        this.statesEnum = Dsmlv2StatesEnum.getInstance();
        this.transitions = (HashMap[])Array.newInstance(HashMap.class, 300);
        this.transitions[0] = new HashMap();
        this.transitions[0].put(new Tag("batchResponse", Tag.START), new GrammarTransition(0, 200, this.batchResponseCreation));
        this.transitions[200] = new HashMap();
        this.transitions[200].put(new Tag("addResponse", Tag.START), new GrammarTransition(200, 219, this.addResponseCreation));
        this.transitions[200].put(new Tag("authResponse", Tag.START), new GrammarTransition(200, 219, this.authResponseCreation));
        this.transitions[200].put(new Tag("compareResponse", Tag.START), new GrammarTransition(200, 219, this.compareResponseCreation));
        this.transitions[200].put(new Tag("delResponse", Tag.START), new GrammarTransition(200, 219, this.delResponseCreation));
        this.transitions[200].put(new Tag("modifyResponse", Tag.START), new GrammarTransition(200, 219, this.modifyResponseCreation));
        this.transitions[200].put(new Tag("modDNResponse", Tag.START), new GrammarTransition(200, 219, this.modDNResponseCreation));
        this.transitions[200].put(new Tag("extendedResponse", Tag.START), new GrammarTransition(200, 206, this.extendedResponseCreation));
        this.transitions[200].put(new Tag("errorResponse", Tag.START), new GrammarTransition(200, 201, this.errorResponseCreation));
        this.transitions[200].put(new Tag("searchResponse", Tag.START), new GrammarTransition(200, 229, this.searchResponseCreation));
        this.transitions[200].put(new Tag("batchResponse", Tag.END), new GrammarTransition(200, -1, null));
        this.transitions[201] = new HashMap();
        this.transitions[203] = new HashMap();
        this.transitions[204] = new HashMap();
        this.transitions[205] = new HashMap();
        this.transitions[201].put(new Tag("message", Tag.START), new GrammarTransition(201, 203, this.errorResponseAddMessage));
        this.transitions[201].put(new Tag("detail", Tag.START), new GrammarTransition(201, 204, this.errorResponseAddDetail));
        this.transitions[203].put(new Tag("errorResponse", Tag.END), new GrammarTransition(203, 200, null));
        this.transitions[203].put(new Tag("detail", Tag.START), new GrammarTransition(203, 204, this.errorResponseAddDetail));
        this.transitions[204].put(new Tag("detail", Tag.END), new GrammarTransition(204, 205, null));
        this.transitions[205].put(new Tag("detail", Tag.END), new GrammarTransition(205, 205, this.errorResponseAddDetail));
        this.transitions[201].put(new Tag("errorResponse", Tag.END), new GrammarTransition(201, 200, null));
        this.transitions[206] = new HashMap();
        this.transitions[207] = new HashMap();
        this.transitions[208] = new HashMap();
        this.transitions[246] = new HashMap();
        this.transitions[209] = new HashMap();
        this.transitions[210] = new HashMap();
        this.transitions[212] = new HashMap();
        this.transitions[214] = new HashMap();
        this.transitions[216] = new HashMap();
        this.transitions[218] = new HashMap();
        this.transitions[206].put(new Tag("control", Tag.START), new GrammarTransition(206, 207, this.ldapResultControlCreation));
        this.transitions[207].put(new Tag("controlValue", Tag.START), new GrammarTransition(207, 246, this.ldapResultControlValueCreation));
        this.transitions[246].put(new Tag("control", Tag.END), new GrammarTransition(246, 208, null));
        this.transitions[207].put(new Tag("control", Tag.END), new GrammarTransition(207, 208, null));
        this.transitions[208].put(new Tag("control", Tag.START), new GrammarTransition(208, 207, this.ldapResultControlCreation));
        this.transitions[208].put(new Tag("resultCode", Tag.START), new GrammarTransition(208, 209, this.extendedResponseAddResultCode));
        this.transitions[206].put(new Tag("resultCode", Tag.START), new GrammarTransition(206, 209, this.extendedResponseAddResultCode));
        this.transitions[209].put(new Tag("resultCode", Tag.END), new GrammarTransition(209, 210, null));
        this.transitions[210].put(new Tag("errorMessage", Tag.START), new GrammarTransition(210, 212, this.extendedResponseAddErrorMessage));
        this.transitions[210].put(new Tag("referral", Tag.START), new GrammarTransition(210, 214, this.extendedResponseAddReferral));
        this.transitions[210].put(new Tag("responseName", Tag.START), new GrammarTransition(210, 216, this.extendedResponseAddResponseName));
        this.transitions[210].put(new Tag("response", Tag.START), new GrammarTransition(210, 218, this.extendedResponseAddResponse));
        this.transitions[210].put(new Tag("extendedResponse", Tag.END), new GrammarTransition(210, 200, null));
        this.transitions[212].put(new Tag("referral", Tag.START), new GrammarTransition(212, 214, this.extendedResponseAddReferral));
        this.transitions[212].put(new Tag("responseName", Tag.START), new GrammarTransition(212, 216, this.extendedResponseAddResponseName));
        this.transitions[212].put(new Tag("response", Tag.START), new GrammarTransition(212, 218, this.extendedResponseAddResponse));
        this.transitions[212].put(new Tag("extendedResponse", Tag.END), new GrammarTransition(212, 200, null));
        this.transitions[214].put(new Tag("referral", Tag.START), new GrammarTransition(214, 214, this.extendedResponseAddReferral));
        this.transitions[214].put(new Tag("responseName", Tag.START), new GrammarTransition(214, 216, this.extendedResponseAddResponseName));
        this.transitions[214].put(new Tag("reponse", Tag.START), new GrammarTransition(214, 218, this.extendedResponseAddResponse));
        this.transitions[214].put(new Tag("extendedResponse", Tag.END), new GrammarTransition(214, 200, null));
        this.transitions[216].put(new Tag("response", Tag.START), new GrammarTransition(216, 218, this.extendedResponseAddResponse));
        this.transitions[216].put(new Tag("extendedResponse", Tag.END), new GrammarTransition(216, 200, null));
        this.transitions[218].put(new Tag("extendedResponse", Tag.END), new GrammarTransition(218, 200, null));
        this.transitions[219] = new HashMap();
        this.transitions[220] = new HashMap();
        this.transitions[221] = new HashMap();
        this.transitions[248] = new HashMap();
        this.transitions[222] = new HashMap();
        this.transitions[223] = new HashMap();
        this.transitions[225] = new HashMap();
        this.transitions[227] = new HashMap();
        this.transitions[244] = new HashMap();
        this.transitions[219].put(new Tag("control", Tag.START), new GrammarTransition(219, 220, this.ldapResultControlCreation));
        this.transitions[219].put(new Tag("resultCode", Tag.START), new GrammarTransition(219, 222, this.ldapResultAddResultCode));
        this.transitions[220].put(new Tag("controlValue", Tag.START), new GrammarTransition(220, 248, this.ldapResultControlValueCreation));
        this.transitions[248].put(new Tag("control", Tag.END), new GrammarTransition(248, 221, null));
        this.transitions[220].put(new Tag("control", Tag.END), new GrammarTransition(220, 221, null));
        this.transitions[221].put(new Tag("control", Tag.START), new GrammarTransition(221, 220, this.ldapResultControlCreation));
        this.transitions[221].put(new Tag("resultCode", Tag.START), new GrammarTransition(221, 222, this.ldapResultAddResultCode));
        this.transitions[222].put(new Tag("resultCode", Tag.END), new GrammarTransition(222, 223, null));
        this.transitions[223].put(new Tag("errorMessage", Tag.START), new GrammarTransition(223, 225, this.ldapResultAddErrorMessage));
        this.transitions[223].put(new Tag("referral", Tag.START), new GrammarTransition(223, 227, this.ldapResultAddReferral));
        this.transitions[223].put(new Tag("addResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("authResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("compareResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("delResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("modifyResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("modDNResponse", Tag.END), new GrammarTransition(223, 200, null));
        this.transitions[223].put(new Tag("searchResultDone", Tag.END), new GrammarTransition(223, 244, null));
        this.transitions[244].put(new Tag("searchResponse", Tag.END), new GrammarTransition(244, 200, null));
        this.transitions[225].put(new Tag("referral", Tag.START), new GrammarTransition(225, 227, this.ldapResultAddReferral));
        this.transitions[225].put(new Tag("addResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("authResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("compareResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("delResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("modifyResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("modDNResponse", Tag.END), new GrammarTransition(225, 200, null));
        this.transitions[225].put(new Tag("searchResultDone", Tag.END), new GrammarTransition(225, 244, null));
        this.transitions[227].put(new Tag("referral", Tag.START), new GrammarTransition(227, 227, this.ldapResultAddReferral));
        this.transitions[227].put(new Tag("addResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("authResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("compareResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("delResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("modifyResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("modDNResponse", Tag.END), new GrammarTransition(227, 200, null));
        this.transitions[227].put(new Tag("searchResultDone", Tag.END), new GrammarTransition(227, 244, null));
        this.transitions[229] = new HashMap();
        this.transitions[229].put(new Tag("searchResultEntry", Tag.START), new GrammarTransition(229, 230, this.searchResultEntryCreation));
        this.transitions[229].put(new Tag("searchResultReference", Tag.START), new GrammarTransition(229, 238, this.searchResultReferenceCreation));
        this.transitions[229].put(new Tag("searchResultDone", Tag.START), new GrammarTransition(229, 219, this.searchResultDoneCreation));
        this.transitions[230] = new HashMap();
        this.transitions[231] = new HashMap();
        this.transitions[232] = new HashMap();
        this.transitions[250] = new HashMap();
        this.transitions[233] = new HashMap();
        this.transitions[234] = new HashMap();
        this.transitions[236] = new HashMap();
        this.transitions[230].put(new Tag("control", Tag.START), new GrammarTransition(230, 231, this.searchResultEntryControlCreation));
        this.transitions[230].put(new Tag("attr", Tag.START), new GrammarTransition(230, 233, this.searchResultEntryAddAttr));
        this.transitions[230].put(new Tag("searchResultEntry", Tag.END), new GrammarTransition(230, 237, null));
        this.transitions[231].put(new Tag("controlValue", Tag.START), new GrammarTransition(231, 250, this.searchResultEntryControlValueCreation));
        this.transitions[250].put(new Tag("control", Tag.END), new GrammarTransition(250, 232, null));
        this.transitions[231].put(new Tag("control", Tag.END), new GrammarTransition(231, 232, null));
        this.transitions[232].put(new Tag("control", Tag.START), new GrammarTransition(232, 231, this.searchResultEntryControlCreation));
        this.transitions[232].put(new Tag("searchResultEntry", Tag.END), new GrammarTransition(232, 237, null));
        this.transitions[232].put(new Tag("attr", Tag.START), new GrammarTransition(232, 233, null));
        this.transitions[233].put(new Tag("attr", Tag.END), new GrammarTransition(233, 234, null));
        this.transitions[233].put(new Tag("value", Tag.START), new GrammarTransition(233, 236, this.searchResultEntryAddValue));
        this.transitions[234].put(new Tag("attr", Tag.START), new GrammarTransition(234, 233, this.searchResultEntryAddAttr));
        this.transitions[234].put(new Tag("searchResultEntry", Tag.END), new GrammarTransition(234, 237, null));
        this.transitions[236].put(new Tag("value", Tag.START), new GrammarTransition(236, 236, this.searchResultEntryAddValue));
        this.transitions[236].put(new Tag("attr", Tag.END), new GrammarTransition(236, 234, null));
        this.transitions[237] = new HashMap();
        this.transitions[237].put(new Tag("searchResultEntry", Tag.START), new GrammarTransition(237, 230, this.searchResultEntryCreation));
        this.transitions[237].put(new Tag("searchResultReference", Tag.START), new GrammarTransition(237, 238, this.searchResultReferenceCreation));
        this.transitions[237].put(new Tag("searchResultDone", Tag.START), new GrammarTransition(237, 219, this.searchResultDoneCreation));
        this.transitions[238] = new HashMap();
        this.transitions[239] = new HashMap();
        this.transitions[240] = new HashMap();
        this.transitions[252] = new HashMap();
        this.transitions[242] = new HashMap();
        this.transitions[238].put(new Tag("control", Tag.START), new GrammarTransition(238, 239, this.searchResultReferenceControlCreation));
        this.transitions[238].put(new Tag("ref", Tag.START), new GrammarTransition(238, 242, this.searchResultReferenceAddRef));
        this.transitions[239].put(new Tag("controlValue", Tag.START), new GrammarTransition(239, 252, this.searchResultReferenceControlValueCreation));
        this.transitions[252].put(new Tag("control", Tag.END), new GrammarTransition(252, 240, null));
        this.transitions[239].put(new Tag("control", Tag.END), new GrammarTransition(239, 240, null));
        this.transitions[240].put(new Tag("control", Tag.START), new GrammarTransition(240, 239, this.searchResultReferenceControlCreation));
        this.transitions[240].put(new Tag("ref", Tag.START), new GrammarTransition(240, 242, this.searchResultReferenceAddRef));
        this.transitions[242].put(new Tag("ref", Tag.START), new GrammarTransition(242, 242, this.searchResultReferenceAddRef));
        this.transitions[242].put(new Tag("searchResultReference", Tag.END), new GrammarTransition(242, 243, null));
        this.transitions[243] = new HashMap();
        this.transitions[243].put(new Tag("searchResultReference", Tag.START), new GrammarTransition(243, 238, this.searchResultReferenceCreation));
        this.transitions[243].put(new Tag("searchResultDone", Tag.START), new GrammarTransition(243, 219, this.searchResultDoneCreation));
    }

    private void createAndAddControl(Dsmlv2Container container, LdapMessageCodec parent) throws XmlPullParserException {
        ControlImpl control = null;
        XmlPullParser xpp = container.getParser();
        String attributeValue = xpp.getAttributeValue("", "type");
        if (attributeValue != null) {
            if (!OID.isOID((String)attributeValue)) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03006", (Object[])new Object[0]), xpp, null);
            }
        } else {
            throw new XmlPullParserException(I18n.err((String)"ERR_03005", (Object[])new Object[0]), xpp, null);
        }
        control = new ControlImpl(attributeValue);
        parent.addControl((Control)control);
        attributeValue = xpp.getAttributeValue("", "criticality");
        if (attributeValue != null) {
            if (attributeValue.equals("true")) {
                control.setCritical(true);
            } else if (attributeValue.equals("false")) {
                control.setCritical(false);
            } else {
                throw new XmlPullParserException(I18n.err((String)"ERR_03007", (Object[])new Object[0]), xpp, null);
            }
        }
    }

    private void createAndAddControlValue(Dsmlv2Container container, LdapMessageCodec parent) throws XmlPullParserException {
        Control control = parent.getCurrentControl();
        XmlPullParser xpp = container.getParser();
        try {
            String typeValue = ParserUtils.getXsiTypeAttributeValue(xpp);
            String nextText = xpp.nextText();
            if (!nextText.equals("")) {
                if (ParserUtils.isBase64BinaryValue(xpp, typeValue)) {
                    control.setValue(Base64.decode((char[])nextText.trim().toCharArray()));
                } else {
                    control.setValue(nextText.trim().getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new XmlPullParserException(I18n.err((String)"ERR_03008", (Object[])new Object[]{e.getMessage()}), xpp, null);
        }
    }

    public static Dsmlv2ResponseGrammar getInstance() {
        return instance;
    }

    static {
        DSMLV2_DESCR_TAGS = new HashSet<String>();
        DSMLV2_DESCR_TAGS.add("success");
        DSMLV2_DESCR_TAGS.add("operationsError");
        DSMLV2_DESCR_TAGS.add("protocolError");
        DSMLV2_DESCR_TAGS.add("timeLimitExceeded");
        DSMLV2_DESCR_TAGS.add("sizeLimitExceeded");
        DSMLV2_DESCR_TAGS.add("compareFalse");
        DSMLV2_DESCR_TAGS.add("compareTrue");
        DSMLV2_DESCR_TAGS.add("authMethodNotSupported");
        DSMLV2_DESCR_TAGS.add("strongAuthRequired");
        DSMLV2_DESCR_TAGS.add("referral");
        DSMLV2_DESCR_TAGS.add("adminLimitExceeded");
        DSMLV2_DESCR_TAGS.add("unavailableCriticalExtension");
        DSMLV2_DESCR_TAGS.add("confidentialityRequired");
        DSMLV2_DESCR_TAGS.add("saslBindInProgress");
        DSMLV2_DESCR_TAGS.add("noSuchAttribute");
        DSMLV2_DESCR_TAGS.add("undefinedAttributeType");
        DSMLV2_DESCR_TAGS.add("inappropriateMatching");
        DSMLV2_DESCR_TAGS.add("constraintViolation");
        DSMLV2_DESCR_TAGS.add("attributeOrValueExists");
        DSMLV2_DESCR_TAGS.add("invalidAttributeSyntax");
        DSMLV2_DESCR_TAGS.add("noSuchObject");
        DSMLV2_DESCR_TAGS.add("aliasProblem");
        DSMLV2_DESCR_TAGS.add("invalidDNSyntax");
        DSMLV2_DESCR_TAGS.add("aliasDereferencingProblem");
        DSMLV2_DESCR_TAGS.add("inappropriateAuthentication");
        DSMLV2_DESCR_TAGS.add("invalidCredentials");
        DSMLV2_DESCR_TAGS.add("insufficientAccessRights");
        DSMLV2_DESCR_TAGS.add("busy");
        DSMLV2_DESCR_TAGS.add("unavailable");
        DSMLV2_DESCR_TAGS.add("unwillingToPerform");
        DSMLV2_DESCR_TAGS.add("loopDetect");
        DSMLV2_DESCR_TAGS.add("namingViolation");
        DSMLV2_DESCR_TAGS.add("objectClassViolation");
        DSMLV2_DESCR_TAGS.add("notAllowedOnNonLeaf");
        DSMLV2_DESCR_TAGS.add("notAllowedOnRDN");
        DSMLV2_DESCR_TAGS.add("entryAlreadyExists");
        DSMLV2_DESCR_TAGS.add("objectClassModsProhibited");
        DSMLV2_DESCR_TAGS.add("affectMultipleDSAs");
        DSMLV2_DESCR_TAGS.add("other");
    }
}

