/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl.certGeneration;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.ldap.extras.extended.CertGenerationRequest;
import org.apache.directory.shared.util.Strings;

public class CertGenerationObject
extends AbstractAsn1Object {
    private CertGenerationRequest request;
    private int requestLength = 0;

    public CertGenerationObject(CertGenerationRequest request) {
        this.request = request;
    }

    public int computeLength() {
        int len = Strings.getBytesUtf8((String)this.request.getTargetDN()).length;
        this.requestLength = 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getIssuerDN()).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getSubjectDN()).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        len = Strings.getBytesUtf8((String)this.request.getKeyAlgorithm()).length;
        this.requestLength += 1 + Value.getNbBytes((int)len) + len;
        return 1 + Value.getNbBytes((int)this.requestLength) + this.requestLength;
    }

    public ByteBuffer encode() throws EncoderException {
        ByteBuffer bb = ByteBuffer.allocate(this.computeLength());
        bb.put(UniversalTag.SEQUENCE.getValue());
        bb.put(Value.getBytes((int)this.requestLength));
        Value.encode((ByteBuffer)bb, (String)this.request.getTargetDN());
        Value.encode((ByteBuffer)bb, (String)this.request.getIssuerDN());
        Value.encode((ByteBuffer)bb, (String)this.request.getSubjectDN());
        Value.encode((ByteBuffer)bb, (String)this.request.getKeyAlgorithm());
        return bb;
    }
}

